/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.dp.commons.ds.repository.services;

import com.mongodb.client.TransactionBody;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import pl.fhframework.dp.commons.ds.repository.exception.DuplicateKeyRuntimeException;
import pl.fhframework.dp.commons.ds.repository.mongo.model.DocumentContent;
import pl.fhframework.dp.commons.ds.repository.mongo.model.HistoryDocumentContent;
import pl.fhframework.dp.commons.ds.repository.mongo.model.HistoryRepositoryDocument;
import pl.fhframework.dp.commons.ds.repository.mongo.model.RepositoryDocument;
import pl.fhframework.dp.commons.ds.repository.springdata.DocumentDAO;
import pl.fhframework.dp.commons.ds.repository.springdata.DokumentContentDAO;
import pl.fhframework.dp.commons.ds.repository.springdata.HistoryDocumentDAO;
import pl.fhframework.dp.commons.ds.repository.springdata.HistoryDokumentContentDAO;
import pl.fhframework.dp.transport.drs.Result;
import pl.fhframework.dp.transport.drs.repository.DeleteDocumentRequest;
import pl.fhframework.dp.transport.drs.repository.DeleteDocumentResponse;
import pl.fhframework.dp.transport.drs.repository.Document;
import pl.fhframework.dp.transport.drs.repository.DocumentHistory;
import pl.fhframework.dp.transport.drs.repository.FindDocumentRequest;
import pl.fhframework.dp.transport.drs.repository.FindDocumentResponse;
import pl.fhframework.dp.transport.drs.repository.GetDocumentHistoryRequest;
import pl.fhframework.dp.transport.drs.repository.GetDocumentHistoryResponse;
import pl.fhframework.dp.transport.drs.repository.GetDocumentRequest;
import pl.fhframework.dp.transport.drs.repository.GetDocumentResponse;
import pl.fhframework.dp.transport.drs.repository.GetDocumentVersionRequest;
import pl.fhframework.dp.transport.drs.repository.GetDocumentVersionResponse;
import pl.fhframework.dp.transport.drs.repository.StoreDocumentRequest;
import pl.fhframework.dp.transport.drs.repository.StoreDocumentResponse;
import pl.fhframework.dp.transport.drs.repository.UpdateDocumentRequest;
import pl.fhframework.dp.transport.drs.repository.UpdateDocumentResponse;
import pl.fhframework.dp.transport.service.IRepositoryService;

@ApplicationScoped
@Component
public class FhdpRepositoryService
implements IRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(FhdpRepositoryService.class);
    @Autowired
    protected DokumentContentDAO dokumentContentDAO;
    @Autowired
    protected DocumentDAO documentDAO;
    @Autowired
    protected HistoryDokumentContentDAO hDokumentContentDAO;
    @Autowired
    protected HistoryDocumentDAO hDocumentDAO;

    public StoreDocumentResponse storeDocument(final StoreDocumentRequest request) {
        StoreDocumentResponse response = new StoreDocumentResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        if (request.getDocument().getId() == null) {
            result.setResultCode(Integer.valueOf(-1));
            result.setResultDescription("ID is required");
            return response;
        }
        if (this.getDocumentDAO().checkIfExists(request.getDocument().getId())) {
            result.setResultCode(Integer.valueOf(-2));
            result.setResultDescription("ID already exists: " + request.getDocument().getId());
            return response;
        }
        try {
            final DocumentContent content = new DocumentContent();
            content.setId(request.getDocument().getId());
            content.setContent(request.getDocument().getContent());
            TransactionBody<String> txnBody = new TransactionBody<String>(){

                public String execute() {
                    try {
                        String hdcId = UUID.randomUUID().toString();
                        RepositoryDocument doc = FhdpRepositoryService.this.getRepositoryDocument(request, content);
                        if (request.getDocument().getOperation() != null && request.getDocument().getOperation().isTrackChanges()) {
                            String hId = UUID.randomUUID().toString();
                            doc.setHistoryContentId(hdcId);
                            HistoryRepositoryDocument hDoc = new HistoryRepositoryDocument(doc, hId);
                            hDoc.setChangedContent(true);
                            DocumentContent docContent = content;
                            HistoryDocumentContent hdContent = new HistoryDocumentContent();
                            hdContent.setContent(docContent.getContent());
                            hdContent.setDocumentId(request.getDocument().getId());
                            hdContent.setDocumentVersion(1);
                            hdContent.setId(hdcId);
                            FhdpRepositoryService.this.hDokumentContentDAO.storeItem(hdContent);
                            FhdpRepositoryService.this.hDocumentDAO.storeItem(hDoc);
                        }
                        FhdpRepositoryService.this.dokumentContentDAO.storeItem(content);
                        FhdpRepositoryService.this.getDocumentDAO().storeItem(doc);
                        if (request.getDocument().getOperation() != null && request.getDocument().getOperation().isTrackChanges()) {
                            FhdpRepositoryService.this.getDocumentDAO().updateObjectProperty(request.getDocument().getId(), "changedContent", false);
                        } else {
                            FhdpRepositoryService.this.getDocumentDAO().updateObjectProperty(request.getDocument().getId(), "changedContent", true);
                        }
                    }
                    catch (DuplicateKeyException ex) {
                        throw new DuplicateKeyRuntimeException(ex);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return "done";
                }
            };
            this.getDocumentDAO().withTransaction(txnBody);
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
            RepositoryDocument rd = (RepositoryDocument)this.getDocumentDAO().getObject(request.getDocument().getId());
            response.setDocument(this.repositoryDocumentToDocument(rd));
        }
        catch (DuplicateKeyRuntimeException e) {
            result.setResultCode(Integer.valueOf(-5));
            result.setResultDescription(e.getMessage());
        }
        catch (Exception e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    public GetDocumentResponse getDocument(GetDocumentRequest request) {
        GetDocumentResponse response = new GetDocumentResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        if (request.getId() == null) {
            if (request.getDbId() != null) {
                return this.getDocumentByDbId(request.getDbId());
            }
            result.setResultCode(Integer.valueOf(-1));
            result.setResultDescription("ID is required");
            return response;
        }
        if (!this.getDocumentDAO().checkIfExists(request.getId())) {
            result.setResultCode(Integer.valueOf(-2));
            result.setResultDescription("There is no document with ID: " + request.getId());
            return response;
        }
        try {
            RepositoryDocument rd = (RepositoryDocument)this.getDocumentDAO().getObject(request.getId());
            Document doc = this.repositoryDocumentToDocument(rd);
            DocumentContent content = (DocumentContent)this.dokumentContentDAO.getObject(request.getId());
            doc.setContent(content.getContent());
            response.setDocument(doc);
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
        }
        catch (IOException e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    private GetDocumentResponse getDocumentByDbId(Long dbId) {
        GetDocumentResponse response = new GetDocumentResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        try {
            RepositoryDocument document = this.getDocumentDAO().getByDbId(dbId);
            if (document == null) {
                result.setResultCode(Integer.valueOf(-2));
                result.setResultDescription("There is no document with ID: " + dbId);
                return response;
            }
            Document doc = this.repositoryDocumentToDocument(document);
            DocumentContent content = (DocumentContent)this.dokumentContentDAO.getObject(document.getId());
            doc.setContent(content.getContent());
            response.setDocument(doc);
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
        }
        catch (IOException e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    public UpdateDocumentResponse updateDocument(final UpdateDocumentRequest request) {
        UpdateDocumentResponse response = new UpdateDocumentResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        if (request.getId() == null) {
            result.setResultCode(Integer.valueOf(-1));
            result.setResultDescription("ID is required");
            return response;
        }
        if (!this.getDocumentDAO().checkIfExists(request.getId())) {
            result.setResultCode(Integer.valueOf(-2));
            result.setResultDescription("There is no document with ID: " + request.getId());
            return response;
        }
        if (!this.getDocumentDAO().checkIfExists(request.getId(), request.getVersion())) {
            result.setResultCode(Integer.valueOf(-3));
            result.setResultDescription("Document version is not " + request.getVersion());
            return response;
        }
        try {
            final byte[] nContent = request.getContent();
            TransactionBody<String> txnBody = new TransactionBody<String>(){

                public String execute() {
                    try {
                        FhdpRepositoryService.this.getDocumentDAO().updateVersion(request.getId(), request.getVersion());
                        if (nContent != null) {
                            DocumentContent content = new DocumentContent();
                            content.setId(request.getId());
                            content.setContent(request.getContent());
                            FhdpRepositoryService.this.dokumentContentDAO.replaceObject(content);
                            FhdpRepositoryService.this.getDocumentDAO().updateObjectProperty(request.getId(), "changedContent", true);
                        }
                        FhdpRepositoryService.this.getDocumentDAO().updateDocument(request);
                        if (request.getOperation() != null && request.getOperation().isTrackChanges()) {
                            String hId = UUID.randomUUID().toString();
                            Object historyDocumentContent = null;
                            RepositoryDocument doc = (RepositoryDocument)FhdpRepositoryService.this.getDocumentDAO().getObject(request.getId());
                            HistoryRepositoryDocument hDoc = new HistoryRepositoryDocument(doc, hId);
                            String hdcId = hDoc.getHistoryContentId();
                            if (hdcId == null) {
                                hdcId = UUID.randomUUID().toString();
                                hDoc.setHistoryContentId(hdcId);
                                DocumentContent docContent = (DocumentContent)FhdpRepositoryService.this.dokumentContentDAO.getObject(request.getId());
                                HistoryDocumentContent hdContent = new HistoryDocumentContent();
                                hdContent.setContent(docContent.getContent());
                                hdContent.setDocumentId(request.getId());
                                hdContent.setDocumentVersion(request.getVersion());
                                hdContent.setId(hdcId);
                                FhdpRepositoryService.this.hDokumentContentDAO.storeItem(hdContent);
                                if (request.getContent() == null) {
                                    FhdpRepositoryService.this.getDocumentDAO().updateObjectProperty(request.getId(), "historyContentId", hdcId);
                                }
                            }
                            FhdpRepositoryService.this.hDocumentDAO.storeItem(hDoc);
                            FhdpRepositoryService.this.getDocumentDAO().updateObjectProperty(request.getId(), "changedContent", false);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return "done";
                }
            };
            this.getDocumentDAO().withTransaction(txnBody);
            RepositoryDocument rd = (RepositoryDocument)this.getDocumentDAO().getObject(request.getId());
            response.setDocument(this.repositoryDocumentToDocument(rd));
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
        }
        catch (Exception e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    public DeleteDocumentResponse deleteDocument(final DeleteDocumentRequest request) {
        DeleteDocumentResponse response = new DeleteDocumentResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        if (request.getId() == null) {
            result.setResultCode(Integer.valueOf(-1));
            result.setResultDescription("ID is required");
            return response;
        }
        if (!this.getDocumentDAO().checkIfExists(request.getId())) {
            result.setResultCode(Integer.valueOf(-2));
            result.setResultDescription("There is no document with ID: " + request.getId());
            return response;
        }
        try {
            TransactionBody<String> txnBody = new TransactionBody<String>(){

                public String execute() {
                    try {
                        Query query = new Query();
                        query = query.addCriteria((CriteriaDefinition)Criteria.where((String)"documentId").is((Object)request.getId()));
                        query = query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"version"}));
                        List sResult = FhdpRepositoryService.this.hDocumentDAO.find(query);
                        if (sResult.size() > 0) {
                            RepositoryDocument rd = (RepositoryDocument)sResult.get(0);
                            DocumentContent content = (DocumentContent)FhdpRepositoryService.this.hDokumentContentDAO.getObject(rd.getHistoryContentId());
                            FhdpRepositoryService.this.dokumentContentDAO.replaceObject(content, true);
                            FhdpRepositoryService.this.getDocumentDAO().replaceObject(rd, true);
                        } else {
                            FhdpRepositoryService.this.dokumentContentDAO.deleteObject(request.getId());
                            FhdpRepositoryService.this.getDocumentDAO().deleteObject(request.getId());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return "done";
                }
            };
            this.getDocumentDAO().withTransaction(txnBody);
            RepositoryDocument rd = (RepositoryDocument)this.getDocumentDAO().getObject(request.getId());
            if (rd != null) {
                response.setDocument(this.repositoryDocumentToDocument(rd));
            }
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
        }
        catch (Exception e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    public FindDocumentResponse findDocument(FindDocumentRequest request) {
        FindDocumentResponse response = new FindDocumentResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        ArrayList filters = new ArrayList();
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            List<RepositoryDocument> sResult = this.getDocumentDAO().find(request);
            for (RepositoryDocument rd : sResult) {
                Document doc = new Document();
                doc.setMetadata(rd.getMetadata());
                doc.setId(rd.getId());
                doc.setVersion(rd.getVersion());
                doc.setCreated(rd.getCreated());
                doc.setModified(rd.getModified());
                documents.add(doc);
            }
            response.setDocuments(documents);
        }
        catch (Exception e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    public GetDocumentHistoryResponse getDocumentHistory(GetDocumentHistoryRequest request) {
        GetDocumentHistoryResponse response = new GetDocumentHistoryResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        if (request.getId() == null) {
            result.setResultCode(Integer.valueOf(-1));
            result.setResultDescription("ID is required");
            return response;
        }
        try {
            ArrayList<DocumentHistory> documents = new ArrayList<DocumentHistory>();
            Criteria criteria = Criteria.where((String)"documentId").is((Object)request.getId());
            if (request.getVersion() != null && request.getVersion() != 0) {
                criteria = criteria.and("version").is((Object)request.getVersion());
            }
            if (request.getOperationName() != null) {
                criteria = criteria.and("operation.name").in((Object[])request.getOperationName());
            }
            Query query = new Query();
            query = query.addCriteria((CriteriaDefinition)criteria);
            query = query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"version"}));
            List sResult = this.hDocumentDAO.find(query);
            for (HistoryRepositoryDocument rd : sResult) {
                DocumentHistory doc = new DocumentHistory();
                doc.setMetadata(rd.getMetadata());
                doc.setOperation(rd.getOperation());
                doc.setId(rd.getId());
                doc.setVersion(rd.getVersion());
                doc.setCreated(rd.getCreated());
                doc.setModified(rd.getModified());
                doc.setChangedContent(rd.isChangedContent());
                if (request.isWithContent() && rd.isChangedContent()) {
                    DocumentContent content = (DocumentContent)this.hDokumentContentDAO.getObject(rd.getHistoryContentId());
                    doc.setContent(content.getContent());
                }
                documents.add(doc);
                if (!request.isLatest()) continue;
                break;
            }
            response.setDocuments(documents);
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
        }
        catch (IOException e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    protected void logException(Exception e) {
        log.error(ExceptionUtils.getStackTrace((Throwable)e));
    }

    public GetDocumentVersionResponse getDocumentVersion(GetDocumentVersionRequest request) {
        GetDocumentVersionResponse response = new GetDocumentVersionResponse();
        Result result = new Result();
        result.setResultCode(Integer.valueOf(-99));
        result.setResultDescription("Unknown Error");
        response.setResult(result);
        if (request.getId() == null) {
            result.setResultCode(Integer.valueOf(-1));
            result.setResultDescription("ID is required");
            return response;
        }
        if (!this.getDocumentDAO().checkIfExists(request.getId())) {
            result.setResultCode(Integer.valueOf(-2));
            result.setResultDescription("There is no document with ID: " + request.getId());
            return response;
        }
        try {
            RepositoryDocument rd = (RepositoryDocument)this.getDocumentDAO().getObject(request.getId());
            response.setVersion(rd.getVersion());
            result.setResultCode(Integer.valueOf(1));
            result.setResultDescription("OK");
        }
        catch (IOException e) {
            this.logException(e);
            result.setResultCode(Integer.valueOf(-99));
            result.setResultDescription(e.getMessage());
        }
        return response;
    }

    protected String getMD5(byte[] content) {
        return DigestUtils.md5Hex((byte[])content);
    }

    protected void repositoryDocumentToDocument(RepositoryDocument rd, Document doc) {
        doc.setMetadata(rd.getMetadata());
        doc.setOperation(rd.getOperation());
        doc.setId(rd.getId());
        doc.setDbId(rd.getDbId());
        doc.setVersion(rd.getVersion());
        doc.setCreated(rd.getCreated());
        doc.setModified(rd.getModified());
    }

    protected Document repositoryDocumentToDocument(RepositoryDocument rd) {
        Document doc = new Document();
        this.repositoryDocumentToDocument(rd, doc);
        return doc;
    }

    protected DocumentDAO getDocumentDAO() {
        return this.documentDAO;
    }

    protected RepositoryDocument getRepositoryDocument(StoreDocumentRequest request, DocumentContent content) {
        RepositoryDocument doc = new RepositoryDocument();
        doc.setMetadata(request.getDocument().getMetadata());
        doc.setOperation(request.getDocument().getOperation());
        doc.setCreated(LocalDateTime.now());
        doc.setId(request.getDocument().getId());
        doc.setDbId(request.getDocument().getDbId());
        doc.setVersion(1);
        doc.setContentSize(content.getContent().length);
        doc.setContentMD5(this.getMD5(content.getContent()));
        return doc;
    }
}

