/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.dp.commons.ds.repository.springdata;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.TransactionBody;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public abstract class BaseDAO<T> {
    @Autowired
    protected MongoClient mongoClient;
    @Autowired
    protected MongoTemplate mongoTemplate;

    protected abstract String getCollectionName();

    protected abstract Class<T> getObjectClass();

    public void storeItem(T item) throws JsonProcessingException {
        this.mongoTemplate.save(item, this.getCollectionName());
    }

    public boolean checkIfExists(String id) {
        Object result = this.mongoTemplate.findById((Object)id, this.getObjectClass(), this.getCollectionName());
        return result != null;
    }

    public void updateObject(T item) throws JsonProcessingException {
        this.mongoTemplate.save(item, this.getCollectionName());
    }

    public void replaceObject(T item) throws JsonProcessingException {
        this.mongoTemplate.save(item, this.getCollectionName());
    }

    public void replaceObject(T item, boolean upsert) throws JsonProcessingException {
        this.mongoTemplate.save(item, this.getCollectionName());
    }

    public void updateObjectProperty(String objectId, String name, Object value) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)objectId));
        Update update = new Update();
        update = update.set(name, value);
        Object result = this.mongoTemplate.update(this.getObjectClass()).inCollection(this.getCollectionName()).matching(query).apply((UpdateDefinition)update).withOptions(FindAndModifyOptions.options().returnNew(true)).findAndModifyValue();
    }

    public void deleteObject(String objectID) throws JsonParseException, JsonMappingException, IOException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)objectID));
        Object result = this.mongoTemplate.findAndRemove(query, this.getObjectClass(), this.getCollectionName());
    }

    public List<T> find(Query query) {
        List result = null;
        result = this.mongoTemplate.find(query, this.getObjectClass(), this.getCollectionName());
        return result;
    }

    public T getObject(String objectID) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.mongoTemplate.findById((Object)objectID, this.getObjectClass(), this.getCollectionName());
    }

    protected ClientSession getSession() {
        return this.mongoClient.startSession();
    }

    protected TransactionOptions getTXOptions() {
        TransactionOptions txnOptions = TransactionOptions.builder().readPreference(ReadPreference.primary()).readConcern(ReadConcern.LOCAL).writeConcern(WriteConcern.ACKNOWLEDGED).build();
        return txnOptions;
    }

    public void withTransaction(TransactionBody<String> txnBody) {
        try (ClientSession session = this.getSession();){
            this.getSession().withTransaction(txnBody, this.getTXOptions());
        }
    }
}

