/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.dp.commons.ds.repository.springdata;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import pl.fhframework.dp.commons.ds.repository.mongo.model.RepositoryDocument;
import pl.fhframework.dp.commons.ds.repository.springdata.BaseDAO;
import pl.fhframework.dp.transport.drs.repository.FindDocumentRequest;
import pl.fhframework.dp.transport.drs.repository.Metadata;
import pl.fhframework.dp.transport.drs.repository.OtherMetadata;
import pl.fhframework.dp.transport.drs.repository.UpdateDocumentRequest;

@Component
public class DocumentDAO
extends BaseDAO<RepositoryDocument> {
    @Value(value="${drs.document.collection.name:fhdp_document}")
    private String collectionName;
    @Autowired
    protected MongoTemplate mongoTemplate;

    @Override
    protected String getCollectionName() {
        return this.collectionName;
    }

    @Override
    protected Class<RepositoryDocument> getObjectClass() {
        return RepositoryDocument.class;
    }

    @Override
    public void storeItem(RepositoryDocument item) {
        this.mongoTemplate.save((Object)item, this.getCollectionName());
    }

    public boolean checkIfExists(String id, int version) {
        List result = this.mongoTemplate.query(RepositoryDocument.class).inCollection(this.getCollectionName()).matching(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id).and("version").is((Object)version))).all();
        return result.size() > 0;
    }

    public RepositoryDocument getByDbId(Long dbId) {
        List result = this.mongoTemplate.query(RepositoryDocument.class).inCollection(this.getCollectionName()).matching(Query.query((CriteriaDefinition)Criteria.where((String)"dbId").is((Object)dbId))).all();
        if (result.isEmpty()) {
            return null;
        }
        return (RepositoryDocument)result.get(0);
    }

    public void updateVersion(String id, int version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id).and("version").is((Object)version));
        Update update = new Update().inc("version", (Number)1);
        RepositoryDocument result = (RepositoryDocument)this.mongoTemplate.update(RepositoryDocument.class).inCollection(this.getCollectionName()).matching(query).apply((UpdateDefinition)update).withOptions(FindAndModifyOptions.options().returnNew(true)).findAndModifyValue();
        if (result == null) {
            throw new RuntimeException("version mismatch");
        }
    }

    public void updateDocument(UpdateDocumentRequest request) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)request.getId()));
        if (request.getOtherMetadata() != null) {
            for (OtherMetadata omd : request.getOtherMetadata()) {
                Update updateOMD = new Update();
                updateOMD = updateOMD.pull("metadata.otherMetadata", (Object)Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)omd.getName())));
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)updateOMD, this.getCollectionName());
                Update updatePush = new Update();
                updatePush = updatePush.push("metadata.otherMetadata", (Object)omd);
                this.mongoTemplate.updateFirst(query, (UpdateDefinition)updatePush, this.getCollectionName());
            }
        }
        Update update = new Update();
        if (request.getContentType() != null) {
            update = update.set("metadata.contentType", (Object)request.getContentType());
        }
        if (request.getLocalReferenceNumber() != null) {
            update = update.set("metadata.localReferenceNumber", (Object)request.getLocalReferenceNumber());
        }
        update = update.set("modified", (Object)new Date());
        if (request.getOperation() != null) {
            update = update.set("operation.name", (Object)request.getOperation().getName());
            update = update.set("operation.description", (Object)request.getOperation().getDescription());
        }
        this.additionalUpdates(update, request);
        RepositoryDocument result = (RepositoryDocument)this.mongoTemplate.update(RepositoryDocument.class).inCollection(this.getCollectionName()).matching(query).apply((UpdateDefinition)update).withOptions(FindAndModifyOptions.options().returnNew(true)).findAndModifyValue();
    }

    protected void additionalUpdates(Update update, UpdateDocumentRequest request) {
    }

    public List<RepositoryDocument> find(FindDocumentRequest request) {
        Query query = new Query();
        Metadata md = request.getMetadata();
        if (md != null) {
            if (md.getContentType() != null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"metadata.contentType").is((Object)md.getContentType()));
            }
            if (md.getLocalReferenceNumber() != null) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"metadata.localReferenceNumber").is((Object)md.getLocalReferenceNumber()));
            }
        }
        if (request.getMetadata() != null && request.getMetadata().getOtherMetadata() != null) {
            for (OtherMetadata omd : request.getMetadata().getOtherMetadata()) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"metadata.otherMetadata").elemMatch(Criteria.where((String)"name").is((Object)omd.getName()).and("value").is((Object)omd.getValue())));
            }
        }
        List result = this.mongoTemplate.find(query, this.getObjectClass(), this.getCollectionName());
        return result;
    }
}

