/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.plugins.fhjpa.standalone;

import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.J2eeUserTransaction;
import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.jdbc.nonxa.AtomikosNonXADataSourceBean;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jta.atomikos.AtomikosProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.boot.orm.jpa.hibernate.SpringJtaPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.jta.JtaTransactionManager;
import pl.fhframework.plugins.fhjpa.standalone.FhJpaConfiguration;

@Configuration
@EnableTransactionManagement(order=2)
@EnableAutoConfiguration
@EnableConfigurationProperties(value={AtomikosProperties.class})
@EnableScheduling
@Profile(value={"!withoutDataSource"})
public class DefaultJpaDatabaseConfiguration {
    @Value(value="${spring.jpa.database-platform:org.hibernate.dialect.H2Dialect}")
    private String dialect;
    @Value(value="${spring.jpa.show-sql:false}")
    private boolean showSql;
    @Value(value="${spring.jpa.hibernate.ddl-auto:update}")
    private String ddlAuto;
    @Value(value="${fh.entity.scan}")
    private String entityPackages;
    @Autowired(required=false)
    List<FhJpaConfiguration> jpaConfigurations = new ArrayList<FhJpaConfiguration>();

    @Bean
    @Qualifier(value="fhDataSource")
    @ConfigurationProperties(prefix="spring.datasource")
    @Primary
    public DataSource fhDataSource() {
        return new AtomikosNonXADataSourceBean();
    }

    @Bean
    @DependsOn(value={"fhTransactionManager"})
    @Primary
    public LocalContainerEntityManagerFactoryBean fhEntityManagerFactory(EntityManagerFactoryBuilder factoryBuilder, @Qualifier(value="fhDataSource") DataSource fhDataSource, SpringJtaPlatform springJtaPlatform) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hibernate.dialect", this.dialect);
        properties.put("hibernate.hbm2ddl.auto", this.ddlAuto);
        properties.put("hibernate.transaction.jta.platform", springJtaPlatform);
        properties.put("hibernate.connection.handling_mode", "DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT");
        properties.put("show_sql", this.showSql);
        properties.put("format_sql", "true");
        EntityManagerFactoryBuilder.Builder builder = factoryBuilder.dataSource(fhDataSource).persistenceUnit("FhPU").packages(this.entityPackages.split(",")).properties(properties).jta(true);
        this.jpaConfigurations.forEach(fhJpaConfiguration -> fhJpaConfiguration.configDefaultBuilder(builder, fhDataSource, springJtaPlatform));
        this.jpaConfigurations.forEach(fhJpaConfiguration -> fhJpaConfiguration.configEntityManagerFactoryBuilder(factoryBuilder, fhDataSource, springJtaPlatform));
        return builder.build();
    }

    @Bean(initMethod="init", destroyMethod="close")
    public UserTransactionManager userTransactionManager(UserTransactionService userTransactionService) {
        UserTransactionManager manager = new UserTransactionManager();
        manager.setStartupTransactionService(false);
        manager.setForceShutdown(true);
        return manager;
    }

    @Bean(initMethod="init", destroyMethod="shutdownForce")
    public UserTransactionServiceImp userTransactionService(AtomikosProperties atomikosProperties) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)atomikosProperties.asProperties());
        String tmpDir = this.createTmpDir();
        properties.put("com.atomikos.icatch.output_dir", tmpDir);
        properties.put("com.atomikos.icatch.log_base_dir", tmpDir);
        properties.put("com.atomikos.icatch.default_jta_timeout", "300000");
        properties.put("com.atomikos.icatch.max_timeout", "300000");
        return new UserTransactionServiceImp(properties);
    }

    private String createTmpDir() {
        try {
            return Files.createTempDirectory("database-tmp", new FileAttribute[0]).toAbsolutePath().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Bean(value={"fhTransactionManager"})
    @Primary
    public JtaTransactionManager transactionManager(UserTransactionManager userTransactionManager) {
        JtaTransactionManager transactionManager = new JtaTransactionManager();
        transactionManager.setTransactionManager((TransactionManager)userTransactionManager);
        transactionManager.setUserTransaction((UserTransaction)new J2eeUserTransaction());
        return transactionManager;
    }

    @Bean
    SpringJtaPlatform springJtaPlatform(JtaTransactionManager transactionManager) {
        return new SpringJtaPlatform(transactionManager);
    }
}

