/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.plugins.fhtomcat;

import java.util.logging.Logger;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.stereotype.Component;

@Component
public class CertAuthServerConnectorConfig
implements WebServerFactoryCustomizer<ConfigurableWebServerFactory> {
    private static final Logger LOGGER = Logger.getLogger(CertAuthServerConnectorConfig.class.getName());
    @Value(value="${fhframework.certAuth.server.port:-1}")
    private int port;
    @Value(value="${fhframework.certAuth.server.keystore:}")
    private String keystore;
    @Value(value="${fhframework.certAuth.server.keystorePass:}")
    private String keystorePass;
    @Value(value="${fhframework.certAuth.server.keystoreType:}")
    private String keystoreType;
    @Value(value="${fhframework.certAuth.server.keystoreAlias:}")
    private String keystoreAlias;
    @Value(value="${fhframework.certAuth.server.truststore:}")
    private String truststore;
    @Value(value="${fhframework.certAuth.server.truststorePass:}")
    private String truststorePass;
    @Value(value="${fhframework.certAuth.server.truststoreType:}")
    private String truststoreType;

    public void customize(ConfigurableWebServerFactory genericContainerFactory) {
        if (!(this.port == -1 && this.keystore.isEmpty() && this.keystorePass.isEmpty() && this.keystoreType.isEmpty() && this.keystoreAlias.isEmpty() && this.truststore.isEmpty() && this.truststorePass.isEmpty() && this.truststoreType.isEmpty())) {
            String finalTruststoreType;
            String finalTruststorePass;
            String finalTruststore;
            if (this.port == -1 || this.keystore.isEmpty() || this.keystorePass.isEmpty()) {
                LOGGER.severe("At least fhframework.certAuth.server.port, .keystore and .keystorePass properties must be set");
                return;
            }
            if (!(genericContainerFactory instanceof TomcatServletWebServerFactory)) {
                LOGGER.severe("Container factory is not a " + TomcatServletWebServerFactory.class.getSimpleName() + ", got " + genericContainerFactory.getClass().getName());
                return;
            }
            TomcatServletWebServerFactory containerFactory = (TomcatServletWebServerFactory)genericContainerFactory;
            LOGGER.info("Adding client SSL certificate authentication connector at port " + this.port);
            Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
            connector.setScheme("https");
            connector.setSecure(true);
            connector.setPort(this.port);
            protocol.setSSLEnabled(true);
            protocol.setClientAuth(SSLHostConfig.CertificateVerification.REQUIRED.name());
            protocol.setKeystoreFile(this.keystore);
            protocol.setKeystorePass(this.keystorePass);
            if (!this.keystoreType.isEmpty()) {
                protocol.setKeystoreType(this.keystoreType);
            }
            if (!this.truststore.isEmpty()) {
                finalTruststore = this.truststore;
                finalTruststorePass = this.truststorePass;
                finalTruststoreType = this.truststoreType;
            } else {
                finalTruststore = this.keystore;
                finalTruststorePass = this.keystorePass;
                finalTruststoreType = this.keystoreType;
                LOGGER.info("Property fhframework.certAuth.server.truststore not set, using keystore as truststore");
            }
            protocol.setTruststoreFile(finalTruststore);
            protocol.setTruststorePass(finalTruststorePass);
            if (!finalTruststoreType.isEmpty()) {
                protocol.setTruststoreType(finalTruststoreType);
            }
            containerFactory.addAdditionalTomcatConnectors(new Connector[]{connector});
        }
    }
}

