/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.pubsub.standalone;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import pl.fhframework.pubsub.MessagePublisher;
import pl.fhframework.pubsub.MessageSubscriber;

@Service
public class StandaloneMessagePublisher
implements MessagePublisher {
    private Map<String, List<MessageSubscriber>> registry = new ConcurrentHashMap<String, List<MessageSubscriber>>();

    @Autowired
    public StandaloneMessagePublisher(List<MessageSubscriber> subscribers) {
        for (MessageSubscriber subscriber : subscribers) {
            List<MessageSubscriber> topicSubscribers = this.registry.get(subscriber.getTopic());
            if (topicSubscribers == null) {
                topicSubscribers = new ArrayList<MessageSubscriber>();
            }
            topicSubscribers.add(subscriber);
            this.registry.put(subscriber.getTopic(), topicSubscribers);
        }
    }

    public void publish(String topic, Object message) {
        List<MessageSubscriber> topicSubscribers = this.registry.get(topic);
        if (!CollectionUtils.isEmpty(topicSubscribers)) {
            topicSubscribers.forEach(subscriber -> new SimpleAsyncTaskExecutor().execute(() -> subscriber.onMessage(message)));
        }
    }

    public StandaloneMessagePublisher() {
    }
}

