/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.core.reports;

import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import pl.fhframework.core.reports.JrReportUtils;
import pl.fhframework.core.reports.datasource.FhReportsObjectDataSource;
import pl.fhframework.core.security.annotations.SystemFunction;
import pl.fhframework.core.services.FhService;
import pl.fhframework.event.EventRegistry;

@FhService(groupName="fhReports", categories={"reports"})
@SystemFunction(value="reportsCore/services/generate")
public class FhReportsService {
    @Autowired
    JrReportUtils jrReportUtils;
    @Autowired
    private EventRegistry eventRegistry;

    public void generatePdfReport(String reportId, Object reportModel, Iterator reportList) {
        Resource pdfReport = this.jrReportUtils.exportReportToPdfFile(reportId, new FhReportsObjectDataSource(reportModel, reportList));
        this.eventRegistry.fireDownloadEvent(pdfReport);
    }

    public void generateXlsReport(String reportId, Object reportModel, Iterator reportList) {
        Resource xlsReport = this.jrReportUtils.exportReportToXlsFile(reportId, new FhReportsObjectDataSource(reportModel, reportList));
        this.eventRegistry.fireDownloadEvent(xlsReport);
    }

    public void generateXlsxReport(String reportId, Object reportModel, Iterator reportList) {
        Resource xlsReport = this.jrReportUtils.exportReportToXlsxFile(reportId, new FhReportsObjectDataSource(reportModel, reportList));
        this.eventRegistry.fireDownloadEvent(xlsReport);
    }
}

