/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.core.reports;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import javax.annotation.PostConstruct;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRVirtualizationHelper;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.DeflateStreamCompression;
import net.sf.jasperreports.engine.util.JRConcurrentSwapFile;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.util.StreamCompression;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import pl.fhframework.ReflectionUtils;
import pl.fhframework.SessionManager;
import pl.fhframework.core.dynamic.DynamicClassName;
import pl.fhframework.core.io.FhResource;
import pl.fhframework.core.reports.FhReportsException;
import pl.fhframework.core.reports.datasource.FhReportsFillSource;
import pl.fhframework.core.reports.datasource.FhReportsObjectDataSource;
import pl.fhframework.core.util.FileUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.format.FhConversionService;
import pl.fhframework.io.FileService;
import pl.fhframework.io.TemporaryResource;
import pl.fhframework.subsystems.ModuleRegistry;
import pl.fhframework.subsystems.Subsystem;

@Service
public class JrReportUtils {
    @Autowired
    private FileService fileService;
    @Autowired
    private FhConversionService conversionService;

    @PostConstruct
    private void initJasper() {
        DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
        JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).setProperty("net.sf.jasperreports.default.pdf.encoding", "ISO-8859-2");
        JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).setProperty("net.sf.jasperreports.extension.registry.factory.fonts", "net.sf.jasperreports.engine.fonts.SimpleFontExtensionsRegistryFactory");
        JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).setProperty("net.sf.jasperreports.extension.registry.factory.simple.font.families", "net.sf.jasperreports.engine.fonts.SimpleFontExtensionsRegistryFactory");
    }

    private JRConcurrentSwapFile getJrSwapFile() {
        try {
            return new JRConcurrentSwapFile(this.fileService.getTempDirectoryInstance().toFile().getAbsolutePath(), 1024, 1024);
        }
        catch (Exception e) {
            throw new FhReportsException("Can't initialize virtualizer for report engine", e);
        }
    }

    protected JasperReport getJasperReport(Class reportClass) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        String moduleId = ModuleRegistry.getModuleId((Class)reportClass);
        Subsystem subsystem = ModuleRegistry.getByName((String)moduleId);
        String reportPath = String.format("%s.jasper", reportClass.getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)));
        try {
            FhResource reportResource = FhResource.get((Resource)resolver.getResource(FileUtils.resolve((FhResource)subsystem.getBaseClassPath(), (String)reportPath).toExternalForm()));
            return (JasperReport)JRLoader.loadObject((URL)reportResource.getURL());
        }
        catch (Exception e) {
            throw new FhReportsException("Can't load compiled report", e);
        }
    }

    public JasperReport getJasperReport(String raportId) {
        Class raportClass = ReflectionUtils.getClassForName((String)raportId);
        return this.getJasperReport(raportClass);
    }

    public FhReportsFillSource dataSourceOf(Object reportModel, Iterator reportIter) {
        return new FhReportsObjectDataSource(reportModel, reportIter);
    }

    public FhReportsFillSource dataSourceOf(Object reportModel, String listIteratorAttr) {
        Iterator iterator = null;
        if (!StringUtils.isNullOrEmpty((String)listIteratorAttr) && (iterator = this.getFieldValue(reportModel, listIteratorAttr)) != null) {
            if (iterator instanceof Iterable) {
                iterator = ((Iterable)((Object)iterator)).iterator();
            } else if (!(iterator instanceof Iterator)) {
                throw new FhReportsException(String.format("Incorrect iterator '%s' for report data source", listIteratorAttr));
            }
        }
        return new FhReportsObjectDataSource(reportModel, iterator);
    }

    public Object getFieldValue(Object object, String field) {
        try {
            return ((Method)ReflectionUtils.findGetter(object.getClass(), (Field)object.getClass().getDeclaredField(field)).get()).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new FhReportsException(String.format("Error while retrieving field '%s'", field), e);
        }
    }

    public Object getFieldValueStr(Object object, String field) {
        try {
            return this.formatValue(this.getFieldValue(object, field));
        }
        catch (Exception e) {
            throw new FhReportsException(String.format("Error while retrieving field '%s'", field), e);
        }
    }

    public Resource exportReportToPdfFile(String raportId, FhReportsFillSource dataSource) {
        return this.exportReport(raportId, dataSource, this::exportToPdf, ".pdf");
    }

    public Resource exportReportToXlsFile(String raportId, FhReportsFillSource dataSource) {
        return this.exportReport(raportId, dataSource, this::exportToXls, ".xls");
    }

    public Resource exportReportToXlsxFile(String raportId, FhReportsFillSource dataSource) {
        return this.exportReport(raportId, dataSource, this::exportToXlsx, ".xlsx");
    }

    protected Resource exportReport(String raportId, FhReportsFillSource dataSource, BiConsumer<JasperPrint, String> exportFunction, String extension) {
        Class raportClass = ReflectionUtils.getClassForName((String)raportId);
        JasperReport jasperReport = this.getJasperReport(raportId);
        return this.exportReport(raportClass, raportId, jasperReport, dataSource, exportFunction, extension);
    }

    protected Resource exportReport(Class raportClass, String raportId, JasperReport jasperReport, FhReportsFillSource dataSource, BiConsumer<JasperPrint, String> exportFunction, String extension) {
        DynamicClassName raportName = DynamicClassName.forClassName((String)raportId);
        Map<String, Object> parameters = dataSource.getValues();
        JRSwapFileVirtualizer virtualizer = new JRSwapFileVirtualizer(1024, (JRSwapFile)this.getJrSwapFile(), true, (StreamCompression)new DeflateStreamCompression(7));
        JRVirtualizationHelper.setThreadVirtualizer((JRVirtualizer)virtualizer);
        parameters.put("REPORT_VIRTUALIZER", virtualizer);
        try {
            LocalJasperReportsContext localJasperReportsContext = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
            localJasperReportsContext.setFileResolver(fileName -> {
                try {
                    String subsystem = (String)((Method)ReflectionUtils.findGetter((Class)raportClass, (String)"subsystemName", Optional.of(String.class)).get()).invoke(null, new Object[0]);
                    FhResource fhResource = ModuleRegistry.getByName((String)subsystem).getBasePath();
                    FhResource absolutePath = fhResource.resolve(raportClass.getPackage().getName().replaceAll("\\.", Matcher.quoteReplacement(File.separator)));
                    FhResource fileResource = absolutePath.resolve(fileName);
                    return fileResource.getExternalPath().toFile();
                }
                catch (Exception e) {
                    throw new FhReportsException("Can't find resource for report", e);
                }
            });
            JasperPrint jasperPrint = JasperFillManager.getInstance((JasperReportsContext)localJasperReportsContext).fill(jasperReport, parameters, (JRDataSource)dataSource);
            virtualizer.setReadOnly(true);
            Path pathToReport = this.fileService.generateHolder(raportName.getBaseClassName() + extension, SessionManager.getUserSession());
            exportFunction.accept(jasperPrint, pathToReport.toFile().getAbsolutePath());
            TemporaryResource temporaryResource = new TemporaryResource(pathToReport.toFile());
            return temporaryResource;
        }
        catch (Exception e) {
            throw new FhReportsException("Can't export report", e);
        }
        finally {
            virtualizer.cleanup();
            JRVirtualizationHelper.clearThreadVirtualizer();
        }
    }

    private void exportToXls(JasperPrint jasperPrint, String path) {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(new File(path)));
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }

    private void exportToXlsx(JasperPrint jasperPrint, String path) {
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(new File(path)));
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }

    private void exportToPdf(JasperPrint jasperPrint, String path) {
        try {
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)path);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }

    private String formatValue(Object value) {
        return (String)this.conversionService.convert(value, String.class);
    }
}

