/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.core.reports.datasource;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.springframework.beans.factory.annotation.Autowired;
import pl.fhframework.ReflectionUtils;
import pl.fhframework.core.reports.FhReportsException;
import pl.fhframework.core.reports.JrReportUtils;
import pl.fhframework.core.reports.datasource.FhReportsFillSource;
import pl.fhframework.format.FhConversionService;
import pl.fhframework.helper.AutowireHelper;

public abstract class FhReportsFillSourceImpl<T, I>
implements FhReportsFillSource<T, I> {
    private T reportModel;
    private Iterator<I> iterator;
    private I currentRow;
    @Autowired
    private FhConversionService conversionService;
    @Autowired
    private JrReportUtils jrReportUtils;

    public FhReportsFillSourceImpl(T reportModel, Iterator<I> iterator) {
        this.reportModel = reportModel;
        this.iterator = iterator;
        AutowireHelper.autowire((Object)this, (Object[])new Object[]{this.conversionService});
    }

    public void moveFirst() throws JRException {
    }

    public boolean next() throws JRException {
        if (this.iterator.hasNext()) {
            this.currentRow = this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    public I getRow() {
        return this.getCurrentRow();
    }

    @Override
    public Map<String, Object> getValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        List properties = ReflectionUtils.getFields(this.reportModel.getClass());
        for (Field property : properties) {
            Optional propertyGetter = ReflectionUtils.findGetter(this.reportModel.getClass(), (Field)property);
            if (!propertyGetter.isPresent()) continue;
            if (!ReflectionUtils.isAssignablFrom(Iterator.class, property.getType()) && !ReflectionUtils.isAssignablFrom(Iterable.class, property.getType())) {
                values.put(property.getName(), this.getPropertyValueStr((Method)propertyGetter.get(), this.reportModel));
            }
            values.put(property.getName() + "$obj", this.getPropertyValue((Method)propertyGetter.get(), this.reportModel));
        }
        values.put("$utils", this.jrReportUtils);
        values.put("$model", this.reportModel);
        return values;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        if ("$row".equals(jrField.getName())) {
            return this.getCurrentRow();
        }
        if (String.class.isAssignableFrom(jrField.getValueClass())) {
            return this.getFieldValueStr(jrField, this.getRow());
        }
        return this.getFieldValue(jrField, this.getRow());
    }

    protected String getFieldValueStr(JRField jrField, I row) {
        try {
            return this.getPropertyValueStr((Method)ReflectionUtils.findGetter(row.getClass(), (Field)row.getClass().getDeclaredField(jrField.getName())).get(), row);
        }
        catch (Exception e) {
            throw new FhReportsException("No value present", e);
        }
    }

    protected Object getFieldValue(JRField jrField, I row) {
        try {
            return this.getPropertyValue((Method)ReflectionUtils.findGetter(row.getClass(), (Field)row.getClass().getDeclaredField(jrField.getName())).get(), row);
        }
        catch (Exception e) {
            throw new FhReportsException("No value present", e);
        }
    }

    private String getPropertyValueStr(Method getter, Object object) {
        try {
            Object value = getter.invoke(object, new Object[0]);
            return this.formatValue(value);
        }
        catch (Exception e) {
            throw new FhReportsException(String.format("Error while retrieving Report value '%s'", getter.getName()), e);
        }
    }

    private Object getPropertyValue(Method getter, Object object) {
        try {
            return getter.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new FhReportsException(String.format("Error while retrieving Report value '%s'", getter.getName()), e);
        }
    }

    public I getCurrentRow() {
        return this.currentRow;
    }

    protected String formatValue(Object value) {
        return (String)this.conversionService.convert(value, String.class);
    }

    @Override
    public T getReportModel() {
        return this.reportModel;
    }

    @Override
    public Iterator<I> getIterator() {
        return this.iterator;
    }
}

