/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme;

import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import pl.koder95.eme.MemoryUtils;
import pl.koder95.eme.Version;
import pl.koder95.eme.au.SelfUpdateTask;
import pl.koder95.eme.core.CabinetWorkers;
import pl.koder95.eme.core.IndexListDataSource;
import pl.koder95.eme.core.SimpleCabinetAnalyzer;
import pl.koder95.eme.core.SuggestionProvider;
import pl.koder95.eme.core.TreeFilingCabinet;
import pl.koder95.eme.core.spi.CabinetAnalyzer;
import pl.koder95.eme.dfs.IndexList;
import pl.koder95.eme.git.RepositoryInfo;

public class Main
extends Application {
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("pl/koder95/eme/strings");
    public static final Locale POLISH = Locale.forLanguageTag("PL-pl");
    public static final Collator DEFAULT_COLLATOR = Collator.getInstance(POLISH);
    private static final String FAV_PATH_START = "pl/koder95/eme/favicon";
    public static final String FAVICON_PATH = "pl/koder95/eme/favicon.png";
    public static final Pattern DIGITS_STRING_PATTERN = Pattern.compile("([0-9]*)");
    public static final boolean IS_WINDOWS_OS = System.getProperty("os.name").toLowerCase().contains("windows");
    private Parent root = null;
    private SelfUpdateTask task = null;

    public static void main(String[] args) {
        if (args.length == 1) {
            if (args[0].equals("-v")) {
                System.out.println(Version.get());
                System.exit(0);
            } else if (args[0].equals("-u")) {
                // empty if block
            }
        }
        Main.launch((String[])args);
    }

    public static void releaseMemory() {
        MemoryUtils.releaseMemory();
    }

    public void init() throws Exception {
        super.init();
        RepositoryInfo.get().reload();
        if (this.getParameters().getUnnamed().isEmpty()) {
            Arrays.stream(IndexList.values()).forEach(IndexList::load);
        }
        TreeFilingCabinet cabinet = new TreeFilingCabinet();
        IndexListDataSource source = new IndexListDataSource();
        SuggestionProvider suggestionProvider = new SuggestionProvider(cabinet);
        SimpleCabinetAnalyzer worker = new SimpleCabinetAnalyzer(cabinet, source, null, suggestionProvider);
        CabinetWorkers.register(CabinetAnalyzer.class, worker);
        worker.load();
        this.root = (Parent)FXMLLoader.load((URL)ClassLoader.getSystemResource("pl/koder95/eme/fx/PersonalDataView.fxml"), (ResourceBundle)BUNDLE);
        this.task = new SelfUpdateTask();
    }

    public void start(Stage primaryStage) {
        primaryStage.getIcons().add((Object)new Image(FAVICON_PATH));
        primaryStage.setTitle("eMetrykant " + Version.get());
        Version latestRelease = RepositoryInfo.get().getLatestReleaseVersion();
        if (!(latestRelease == null || latestRelease.compareTo(Version.get()) <= 0 && this.getParameters().getUnnamed().isEmpty())) {
            ProgressBar updating = new ProgressBar();
            Label title = new Label();
            Label message = new Label();
            VBox root = new VBox(5.0, new Node[]{title, updating, message});
            updating.setMinSize(400.0, 35.0);
            updating.progressProperty().bind((ObservableValue)this.task.progressProperty());
            title.textProperty().bind((ObservableValue)this.task.titleProperty());
            message.textProperty().bind((ObservableValue)this.task.messageProperty());
            root.setAlignment(Pos.CENTER);
            primaryStage.initStyle(StageStyle.UTILITY);
            primaryStage.setScene(new Scene((Parent)root));
            primaryStage.setAlwaysOnTop(true);
            primaryStage.setResizable(false);
            primaryStage.setMinWidth(400.0);
            primaryStage.setMinHeight(100.0);
            primaryStage.show();
            new Thread((Runnable)((Object)this.task)).start();
        } else {
            primaryStage.setScene(new Scene(this.root));
            primaryStage.setOnCloseRequest(event -> System.exit(0));
            primaryStage.show();
        }
    }
}

