/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import pl.koder95.eme.Main;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean preRelease;
    private final Collection<String> identifiers;
    private final Collection<String> buildMetadata;

    public Version(int major, int minor, int patch, boolean preRelease, Collection<String> identifiers, Collection<String> buildMetadata) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException();
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.identifiers = identifiers;
        this.buildMetadata = buildMetadata;
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, false, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final int compareTo(Version o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.minor > o.minor) {
            return 1;
        }
        if (this.minor < o.minor) {
            return -1;
        }
        if (this.patch > o.patch) {
            return 1;
        }
        if (this.patch < o.patch) {
            return -1;
        }
        if (!this.preRelease && !o.preRelease) {
            return 0;
        }
        if (this.preRelease && !o.preRelease) {
            return -1;
        }
        if (!this.preRelease && o.preRelease) {
            return 1;
        }
        if (this.identifiers == o.identifiers) {
            return 0;
        }
        Iterator<String> i0 = this.identifiers.iterator();
        Iterator<String> i1 = o.identifiers.iterator();
        if (!i0.hasNext()) {
            if (!i1.hasNext()) return 0;
        }
        if (i0.hasNext() && i1.hasNext()) {
            String firstS = i0.next();
            String secondS = i1.next();
            int firstI = -1;
            int secondI = -1;
            try {
                firstI = Integer.parseInt(firstS);
                secondI = Integer.parseInt(secondS);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (firstI >= 0) {
                if (secondI < 0) return -1;
                if (firstI < secondI) {
                    return -1;
                }
                if (firstI <= secondI) return 1;
                return 1;
            }
            if (secondI >= 0) {
                return 1;
            }
            int compareTo = firstS.compareTo(secondS);
            if (compareTo == 0) return 1;
            if (compareTo <= 0) return -1;
            return 1;
        }
        if (i0.hasNext()) return 1;
        if (!i1.hasNext()) return 1;
        return -1;
    }

    public Collection<String> getBuildMetadata() {
        return this.buildMetadata;
    }

    public Collection<String> getIdentifiers() {
        return this.isPreRelease() ? this.identifiers : null;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isPreRelease() {
        return this.preRelease;
    }

    public String toString() {
        String stable = this.major + "." + this.minor + "." + this.patch;
        if (this.preRelease) {
            StringBuilder builder = new StringBuilder(stable + "-");
            this.identifiers.forEach(i -> builder.append((String)i).append('.'));
            builder.deleteCharAt(builder.length() - 1);
            if (!this.buildMetadata.isEmpty()) {
                builder.append('+');
                this.buildMetadata.forEach(bMd -> builder.append((String)bMd).append('.'));
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
        return stable;
    }

    private static Version parse0(String str) {
        String[] stableParts;
        boolean isPreRelease = str.contains("-");
        boolean hasBuildMetadata = str.contains("+");
        if (hasBuildMetadata) {
            String[] mainParts = str.split(Pattern.quote("+"));
            Version r = Version.parse0(mainParts[0]);
            if (r == null) {
                return null;
            }
            return new Version(r.major, r.minor, r.patch, r.preRelease, r.identifiers, Arrays.asList(mainParts[1].split(Pattern.quote("."))));
        }
        if (isPreRelease) {
            String[] nonBuildParts = str.split(Pattern.quote("-"));
            String[] preReleaseParts = nonBuildParts[1].split(Pattern.quote("."));
            Version r = Version.parse0(nonBuildParts[0]);
            if (r == null) {
                return null;
            }
            return new Version(r.major, r.minor, r.patch, true, Arrays.asList(preReleaseParts), Collections.emptyList());
        }
        for (String part : stableParts = str.split(Pattern.quote("."))) {
            if (part.matches("(\\d)+")) continue;
            return null;
        }
        return new Version(Integer.parseInt(stableParts[0]), Integer.parseInt(stableParts[1]), Integer.parseInt(stableParts[2]));
    }

    public static Version parse(String str) {
        return Version.parse0(str == null ? "0.0.0" : (str.startsWith("v") ? str.substring(1) : str));
    }

    public static Version parse(Class<?> klasa) {
        try {
            Method get = Arrays.stream(klasa.getMethods()).reduce(null, (r, c) -> c.getName().equals("get") ? c : r);
            if (get != null) {
                return Version.parse(get.invoke(null, new Object[0]).toString());
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return null;
        }
    }

    public static Version get() {
        return Version.parse(Main.class.getPackage().getSpecificationVersion());
    }
}

