/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.au;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.application.Platform;
import javafx.concurrent.Task;
import pl.koder95.eme.Files;
import pl.koder95.eme.au.UpdateScriptGenerator;
import pl.koder95.eme.git.RepositoryInfo;

public class SelfUpdateTask
extends Task<Void> {
    private static final UpdateScriptGenerator US_GENERATOR = UpdateScriptGenerator.create(Files.UPDATE_SCRIPT);

    protected Void call() throws Exception {
        java.nio.file.Files.walk(Files.TEMP_DIR, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                java.nio.file.Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        if (this.extractZip(this.downloadZip())) {
            HashMap<Path, Path> updateMap = new HashMap<Path, Path>();
            java.nio.file.Files.list(Files.TEMP_DIR).forEach(path -> updateMap.put((Path)path, Files.WORKDIR.resolve(path.getFileName().toString())));
            US_GENERATOR.generateUpdateScript(updateMap);
        }
        SelfUpdateTask.restart();
        return null;
    }

    private Path downloadZip() throws IOException {
        this.updateTitle("Pobieranie " + RepositoryInfo.get().getLatestReleaseName());
        return this.tryTransfer(RepositoryInfo.get().getLatestReleaseBrowserURL());
    }

    private Path tryTransfer(String urlSpec) throws IOException {
        Path forDownload = Files.TEMP_DIR.resolve(RepositoryInfo.get().getLatestReleaseName());
        java.nio.file.Files.deleteIfExists(forDownload);
        java.nio.file.Files.createDirectories(forDownload.getParent(), new FileAttribute[0]);
        java.nio.file.Files.createFile(forDownload, new FileAttribute[0]);
        URL url = new URL(urlSpec);
        System.out.println("Downloading: " + forDownload);
        this.updateProgress(0L, 1L);
        try (ReadableByteChannel rbc = Channels.newChannel(url.openStream());
             FileChannel channel = FileChannel.open(forDownload, StandardOpenOption.WRITE);){
            this.transfer(rbc, channel);
        }
        if (java.nio.file.Files.isRegularFile(forDownload, new LinkOption[0])) {
            return forDownload;
        }
        java.nio.file.Files.deleteIfExists(forDownload);
        return null;
    }

    private void transfer(ReadableByteChannel rbc, FileChannel channel) throws IOException {
        System.out.println("TRANSFERRING TO: " + channel);
        long size = RepositoryInfo.get().getLatestReleaseSize();
        channel.truncate(size);
        long count = size > 100L ? size / 100L : 1L;
        long workDone = 0L;
        this.updateProgress(workDone, size);
        while (workDone < size) {
            long transferred = channel.transferFrom(rbc, workDone, count);
            this.updateMessage(NumberFormat.getPercentInstance().format((double)(workDone += transferred) / (double)size));
            this.updateProgress(workDone, size);
        }
        channel.force(true);
    }

    private boolean extractZip(Path forExtract) throws IOException {
        this.updateTitle("Rozpakowywanie " + forExtract.getFileName());
        this.updateProgress(0L, 1L);
        this.updateMessage("");
        try (ZipFile zip = new ZipFile(forExtract.toFile());){
            this.updateProgress(0L, java.nio.file.Files.size(forExtract));
            Enumeration<? extends ZipEntry> entries = zip.entries();
            long total = this.getTotal(zip);
            long workDone = 0L;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path outFile = Files.TEMP_DIR.resolve(entry.getName());
                java.nio.file.Files.deleteIfExists(outFile);
                if (!entry.isDirectory()) {
                    java.nio.file.Files.createFile(outFile, new FileAttribute[0]);
                    if (!java.nio.file.Files.isRegularFile(outFile, new LinkOption[0])) continue;
                    this.tryTransfer(zip, entry, outFile, workDone, total);
                    continue;
                }
                if (!java.nio.file.Files.notExists(outFile, new LinkOption[0])) continue;
                java.nio.file.Files.createDirectories(outFile, new FileAttribute[0]);
            }
            this.updateProgress(1.0, 1.0);
            this.updateTitle("Zako\u0144czono wypakowywanie archiwum");
        }
        this.updateProgress(Double.NaN, 0.0);
        return java.nio.file.Files.deleteIfExists(forExtract);
    }

    private long getTotal(ZipFile zip) throws IOException {
        long total = 0L;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream input = zip.getInputStream(entry);
            int available = input.available();
            total += (long)available;
        }
        return total;
    }

    private void tryTransfer(ZipFile zip, ZipEntry entry, Path outFile, long workDone, long total) throws IOException {
        try (InputStream input = zip.getInputStream(entry);
             OutputStream output = java.nio.file.Files.newOutputStream(outFile, new OpenOption[0]);){
            this.transfer(input, output, workDone, total);
        }
    }

    private void transfer(InputStream input, OutputStream output, long workDone, long total) throws IOException {
        while (input.available() > 0) {
            int b = input.read();
            output.write(b);
            output.flush();
            this.updateProgress(++workDone, total);
            this.updateMessage(NumberFormat.getPercentInstance().format((double)workDone / (double)total));
        }
    }

    private static void restart() {
        Platform.exit();
        try {
            new ProcessBuilder(US_GENERATOR.getPath().toString()).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

