/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.au;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import pl.koder95.eme.Files;
import pl.koder95.eme.Main;

public class UpdateScriptGenerator {
    private static final String WIN_EXT = ".bat";
    private final Path path;

    private UpdateScriptGenerator(Path out) {
        this.path = out;
    }

    public Path getPath() {
        return this.path;
    }

    public static UpdateScriptGenerator create(Path out) {
        return new UpdateScriptGenerator(Main.IS_WINDOWS_OS ? (out.endsWith(WIN_EXT) ? out : Paths.get(out + WIN_EXT, new String[0])) : out);
    }

    public void generateUpdateScript(Map<Path, Path> updateMap) throws IOException {
        if (java.nio.file.Files.notExists(this.path, new LinkOption[0])) {
            java.nio.file.Files.createFile(this.path, new FileAttribute[0]);
        }
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(this.path, StandardOpenOption.WRITE);){
            if (this.path.endsWith(WIN_EXT)) {
                this.generateWinUpdateScript(writer, updateMap);
            } else {
                this.generateUnixScript(writer, updateMap);
            }
        }
    }

    private void generateUnixScript(BufferedWriter writer, Map<Path, Path> updateMap) throws IOException {
        writer.write("$ set echo off");
        writer.newLine();
        writer.write("sleep 5");
        writer.newLine();
        for (Map.Entry<Path, Path> entry : updateMap.entrySet()) {
            Path oldFile = entry.getValue();
            Path newFile = entry.getKey();
            if (java.nio.file.Files.exists(newFile, new LinkOption[0])) {
                writer.write("cp -r \"");
                writer.write(newFile.toString());
                writer.write("\" \"");
                writer.write(oldFile.toString());
                writer.write("\" /y");
                writer.newLine();
                writer.write("rmdir -r \"");
                writer.write(oldFile.getParent().toString());
                writer.write("\" /y");
                writer.newLine();
                continue;
            }
            throw new FileNotFoundException(Main.BUNDLE.getString("THR_UPDATE_FILES_NOT_FOUND"));
        }
        writer.write("java -jar \"" + Files.SELF + '\"');
        writer.newLine();
    }

    private void generateWinUpdateScript(BufferedWriter writer, Map<Path, Path> updateMap) throws IOException {
        writer.write("@echo off");
        writer.newLine();
        writer.write("timeout /T 5 /nobreak > nul");
        writer.newLine();
        for (Map.Entry<Path, Path> entry : updateMap.entrySet()) {
            Path oldFile = entry.getValue();
            Path newFile = entry.getKey();
            if (java.nio.file.Files.exists(newFile, new LinkOption[0])) {
                writer.write("copy \"");
                writer.write(newFile.toString());
                writer.write("\" \"");
                writer.write(oldFile.toString());
                writer.write("\" /y");
                writer.newLine();
                writer.write("rmdir -r \"");
                writer.write(oldFile.getParent().toString());
                writer.write("\" /y");
                writer.newLine();
                continue;
            }
            throw new FileNotFoundException(Main.BUNDLE.getString("THR_UPDATE_FILES_NOT_FOUND"));
        }
        writer.write("java -jar \"" + Files.SELF + '\"');
        writer.newLine();
    }
}

