/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.core;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import pl.koder95.eme.core.AbstractCabinetWorker;
import pl.koder95.eme.core.spi.Briefcase;
import pl.koder95.eme.core.spi.CabinetAnalyzer;
import pl.koder95.eme.core.spi.DataSource;
import pl.koder95.eme.core.spi.DataTarget;
import pl.koder95.eme.core.spi.FilingCabinet;
import pl.koder95.eme.core.spi.PersonalDataModel;

public abstract class AbstractCabinetAnalyzer
extends AbstractCabinetWorker
implements CabinetAnalyzer {
    private final Callback<AutoCompletionBinding.ISuggestionRequest, Collection<PersonalDataModel>> suggestionProvider;
    private final StringConverter<PersonalDataModel> converter;
    private float numberOfActs;

    public AbstractCabinetAnalyzer(FilingCabinet cabinet, DataSource source, DataTarget target, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<PersonalDataModel>> suggestionProvider, StringConverter<PersonalDataModel> converter) {
        super(cabinet, source, target);
        this.suggestionProvider = suggestionProvider;
        this.converter = converter;
    }

    public AbstractCabinetAnalyzer(FilingCabinet cabinet, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<PersonalDataModel>> suggestionProvider, StringConverter<PersonalDataModel> converter) {
        super(cabinet);
        this.suggestionProvider = suggestionProvider;
        this.converter = converter;
    }

    @Override
    public Callback<AutoCompletionBinding.ISuggestionRequest, Collection<PersonalDataModel>> getSuggestionProvider() {
        return this.suggestionProvider;
    }

    @Override
    public StringConverter<PersonalDataModel> getPersonalDataConverter() {
        return this.converter;
    }

    @Override
    public int getNumberOfActs() {
        return Math.round(this.numberOfActs);
    }

    @Override
    public void load() {
        Map<String, Set<String>> personalData = this.getDataSource().getPersonalData();
        personalData.forEach((surname, names) -> names.forEach(name -> {
            DataSource dataSource = this.getDataSource();
            Briefcase briefcase = this.createBriefcase(dataSource.getBaptism((String)surname, (String)name), dataSource.getConfirmation((String)surname, (String)name), dataSource.getMarriage((String)surname, (String)name), dataSource.getDecease((String)surname, (String)name));
            this.numberOfActs += (float)briefcase.getBaptism().length;
            this.numberOfActs += (float)briefcase.getConfirmation().length;
            this.numberOfActs += (float)briefcase.getMarriage().length / 2.0f;
            this.numberOfActs += (float)briefcase.getDecease().length;
            this.getCabinet().add((String)surname, (String)name, briefcase);
        }));
    }
}

