/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.core;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import pl.koder95.eme.core.spi.Briefcase;
import pl.koder95.eme.core.spi.FilingCabinet;

public class AbstractFilingCabinet
implements FilingCabinet {
    private final MapFactory mapFactory;
    private final Map<String, Map<String, Briefcase>> map;
    private final Map<String, Set<String>> personalData;
    private final NameSetFactory nameSetFactory;

    public AbstractFilingCabinet(Map<String, Map<String, Briefcase>> map, MapFactory mapFactory, Map<String, Set<String>> personalData, NameSetFactory nameSetFactory) {
        this.mapFactory = mapFactory;
        this.map = map;
        this.personalData = personalData == null ? new TreeMap() : personalData;
        this.nameSetFactory = nameSetFactory == null ? TreeSet::new : nameSetFactory;
    }

    public AbstractFilingCabinet(Map<String, Map<String, Briefcase>> map, MapFactory mapFactory) {
        this(map, mapFactory, null, null);
    }

    @Override
    public void add(String surname, String name, Briefcase b) {
        if (!this.map.containsKey(surname)) {
            Map<String, Briefcase> map = this.mapFactory.create();
            if (!map.isEmpty()) {
                map.clear();
            }
            this.map.put(surname, map);
        }
        Map<String, Briefcase> briefcaseMap = this.map.get(surname);
        briefcaseMap.put(name, b);
    }

    @Override
    public void remove(String surname, String name) {
        Map<String, Briefcase> briefcaseMap = this.map.get(surname);
        if (briefcaseMap == null) {
            return;
        }
        Briefcase briefcase = briefcaseMap.get(name);
        if (briefcase != null) {
            briefcaseMap.remove(briefcase);
        }
        if (briefcaseMap.isEmpty()) {
            this.map.remove(briefcaseMap);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Map<String, Briefcase> get(String surname) {
        if (!this.personalData.isEmpty() && !this.personalData.containsKey(surname)) {
            throw new SecurityException("You cannot read this data.");
        }
        return this.map.get(surname);
    }

    @Override
    public Briefcase get(String surname, String name) {
        if (!this.personalData.isEmpty() && this.personalData.containsKey(surname) && !this.personalData.get(surname).contains(name)) {
            throw new SecurityException("You cannot read this data.");
        }
        Map<String, Briefcase> briefcaseMap = this.get(surname);
        if (briefcaseMap == null) {
            return null;
        }
        return briefcaseMap.get(name);
    }

    @Override
    public Map<String, Set<String>> getPersonalData() {
        if (this.personalData.isEmpty()) {
            return AbstractFilingCabinet.createPersonalData(this, this.personalData, this.nameSetFactory);
        }
        return this.personalData;
    }

    private static Map<String, Set<String>> createPersonalData(AbstractFilingCabinet cabinet, Map<String, Set<String>> personalDataIdentity, NameSetFactory nameSetFactory) {
        return cabinet.map.entrySet().stream().reduce(personalDataIdentity, (tm, e) -> {
            String key = (String)e.getKey();
            Map value = (Map)e.getValue();
            if (value == null) {
                return tm;
            }
            if (!tm.containsKey(key)) {
                Set<String> set = nameSetFactory.create();
                if (!set.isEmpty()) {
                    set.clear();
                }
                tm.put(key, set);
            }
            ((Set)tm.get(key)).addAll(value.keySet());
            return tm;
        }, (r, c) -> {
            c.forEach((s, ns) -> {
                if (!r.containsKey(s)) {
                    Set<String> set = nameSetFactory.create();
                    if (!set.isEmpty()) {
                        set.clear();
                    }
                    r.put(s, set);
                }
                ((Set)r.get(s)).addAll(ns);
            });
            c.clear();
            return r;
        });
    }

    public static interface NameSetFactory {
        public Set<String> create();
    }

    public static interface MapFactory {
        public Map<String, Briefcase> create();
    }
}

