/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.core;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import pl.koder95.eme.Visitor;
import pl.koder95.eme.core.spi.DataSource;
import pl.koder95.eme.dfs.ActNumber;
import pl.koder95.eme.dfs.Index;
import pl.koder95.eme.dfs.IndexContainer;

public class IndexContainerDataSource
implements DataSource,
Visitor<Index> {
    private final Map<String, Map<String, Set<ActNumber>>> baptisms = new TreeMap<String, Map<String, Set<ActNumber>>>();
    private final Map<String, Map<String, Set<ActNumber>>> confirmations = new TreeMap<String, Map<String, Set<ActNumber>>>();
    private final Map<String, Map<String, Set<ActNumber>>> marriages = new TreeMap<String, Map<String, Set<ActNumber>>>();
    private final Map<String, Map<String, Set<ActNumber>>> deceases = new TreeMap<String, Map<String, Set<ActNumber>>>();
    private final Map<String, Set<String>> personalData = new TreeMap<String, Set<String>>();
    private static final String UTF8_BOM = "\ufeff";

    public IndexContainerDataSource(IndexContainer container) {
        if (container != null) {
            container.getLoaded().forEach(this::visit);
        }
    }

    @Override
    public ActNumber[] getBaptism(String surname, String name) {
        return IndexContainerDataSource.get(this.baptisms, surname, name);
    }

    @Override
    public ActNumber[] getConfirmation(String surname, String name) {
        return IndexContainerDataSource.get(this.confirmations, surname, name);
    }

    @Override
    public ActNumber[] getMarriage(String surname, String name) {
        return IndexContainerDataSource.get(this.marriages, surname, name);
    }

    @Override
    public ActNumber[] getDecease(String surname, String name) {
        return IndexContainerDataSource.get(this.deceases, surname, name);
    }

    @Override
    public Map<String, Set<String>> getPersonalData() {
        return this.personalData;
    }

    private static ActNumber[] get(Map<String, Map<String, Set<ActNumber>>> map, String surname, String name) {
        for (Map.Entry<String, Map<String, Set<ActNumber>>> entry : map.entrySet()) {
            if (!entry.getKey().equals(surname)) continue;
            for (Map.Entry<String, Set<ActNumber>> e : entry.getValue().entrySet()) {
                if (!e.getKey().equals(name)) continue;
                if (e.getValue() == null) {
                    return new ActNumber[0];
                }
                return e.getValue().toArray(new ActNumber[0]);
            }
        }
        return null;
    }

    private void set(Map<String, Map<String, Set<ActNumber>>> map, String surname, String name, ActNumber number) {
        Map<String, Set<ActNumber>> namesMap;
        surname = IndexContainerDataSource.removeUTF8BOM(surname.trim());
        name = IndexContainerDataSource.removeUTF8BOM(name.trim());
        if (!map.containsKey(surname)) {
            map.put(surname, new TreeMap());
        }
        if (!(namesMap = map.get(surname)).containsKey(name)) {
            namesMap.put(name, new LinkedHashSet());
        }
        Set<ActNumber> numbers = namesMap.get(name);
        numbers.add(number);
        if (!this.personalData.containsKey(surname)) {
            this.personalData.put(surname, new TreeSet());
        }
        Set<String> names = this.personalData.get(surname);
        names.add(name);
    }

    private void setBaptism(Index i) {
        this.set(this.baptisms, i.getData("surname"), i.getData("name"), i.getActNumber());
    }

    private void setConfirmation(Index i) {
        this.set(this.confirmations, i.getData("surname"), i.getData("name"), i.getActNumber());
    }

    private void setMarriage(Index i) {
        this.set(this.marriages, i.getData("husband-surname"), i.getData("husband-name"), i.getActNumber());
        this.set(this.marriages, i.getData("wife-surname"), i.getData("wife-name"), i.getActNumber());
    }

    private void setDecease(Index i) {
        this.set(this.deceases, i.getData("surname"), i.getData("name"), i.getActNumber());
    }

    @Override
    public void visit(Index i) {
        String bookName = i.getOwner().getName();
        if (bookName.equalsIgnoreCase("Ksi\u0119ga ochrzczonych")) {
            this.setBaptism(i);
        } else if (bookName.equalsIgnoreCase("Ksi\u0119ga bierzmowanych")) {
            this.setConfirmation(i);
        } else if (bookName.equalsIgnoreCase("Ksi\u0119ga za\u015blubionych")) {
            this.setMarriage(i);
        } else if (bookName.equalsIgnoreCase("Ksi\u0119ga zmar\u0142ych")) {
            this.setDecease(i);
        }
    }

    private static String removeUTF8BOM(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }
}

