/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pl.koder95.eme.core.IndexContainerDataSource;
import pl.koder95.eme.core.spi.DataSource;
import pl.koder95.eme.dfs.ActNumber;
import pl.koder95.eme.dfs.IndexList;

public class IndexListDataSource
implements DataSource {
    private final IndexContainerDataSource baptisms = new IndexContainerDataSource(IndexList.LIBER_BAPTISMORUM);
    private final IndexContainerDataSource confirmations = new IndexContainerDataSource(IndexList.LIBER_CONFIRMATORUM);
    private final IndexContainerDataSource marriages = new IndexContainerDataSource(IndexList.LIBER_MATRIMONIORUM);
    private final IndexContainerDataSource deceases = new IndexContainerDataSource(IndexList.LIBER_DEFUNCTORUM);
    private Map<String, Set<String>> personalData;

    @Override
    public ActNumber[] getBaptism(String surname, String name) {
        return this.baptisms.getBaptism(surname, name);
    }

    @Override
    public ActNumber[] getConfirmation(String surname, String name) {
        return this.confirmations.getConfirmation(surname, name);
    }

    @Override
    public ActNumber[] getMarriage(String surname, String name) {
        return this.marriages.getMarriage(surname, name);
    }

    @Override
    public ActNumber[] getDecease(String surname, String name) {
        return this.deceases.getDecease(surname, name);
    }

    @Override
    public Map<String, Set<String>> getPersonalData() {
        if (this.personalData == null) {
            Map<String, Set<String>> merge0 = IndexListDataSource.merge(this.baptisms.getPersonalData(), this.confirmations.getPersonalData());
            Map<String, Set<String>> merge1 = IndexListDataSource.merge(this.marriages.getPersonalData(), this.deceases.getPersonalData());
            Map<String, Set<String>> finalMerge = IndexListDataSource.merge(merge0, merge1);
            merge0.clear();
            merge1.clear();
            this.personalData = finalMerge;
        }
        return this.personalData;
    }

    private static Map<String, Set<String>> merge(Map<String, Set<String>> pdata0, Map<String, Set<String>> pdata1) {
        TreeMap<String, Set<String>> merged = new TreeMap<String, Set<String>>(pdata0);
        pdata1.forEach((surname, names) -> {
            if (!merged.containsKey(surname)) {
                merged.put((String)surname, new HashSet());
            }
            ((Set)merged.get(surname)).addAll(names);
        });
        return merged;
    }
}

