/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.core;

import java.util.Arrays;
import java.util.function.Function;
import javafx.util.StringConverter;
import pl.koder95.eme.core.spi.Briefcase;
import pl.koder95.eme.core.spi.FilingCabinet;
import pl.koder95.eme.core.spi.PersonalDataModel;
import pl.koder95.eme.dfs.ActNumber;

public class PersonalDataModelConverter
extends StringConverter<PersonalDataModel> {
    private final FilingCabinet cabinet;

    public PersonalDataModelConverter(FilingCabinet cabinet) {
        this.cabinet = cabinet;
    }

    public String toString(PersonalDataModel object) {
        return object.getSurname() + " " + object.getName();
    }

    public PersonalDataModel fromString(String string) {
        if (string != null && !string.isEmpty() && string.contains(" ")) {
            string = this.capitalize(string);
            String beforeSpace = string.substring(0, string.indexOf(32));
            String afterSpace = string.substring(string.indexOf(32) + 1);
            return this.fromBriefcase(beforeSpace, afterSpace);
        }
        return null;
    }

    private String capitalize(String string) {
        String[] words = string.split(" ");
        StringBuilder builder = Arrays.stream(words).map(word -> {
            String transformed = word.toLowerCase();
            char first = transformed.charAt(0);
            return Character.toUpperCase(first) + transformed.substring(1);
        }).reduce(new StringBuilder(), (b, s) -> b.append((String)s).append(" "), StringBuilder::append);
        builder.setLength(string.length());
        string = builder.toString();
        if (string.contains("_")) {
            words = string.split("_");
            builder = Arrays.stream(words).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).reduce(new StringBuilder(), (b, s) -> b.append((String)s).append("_"), StringBuilder::append);
            builder.setLength(string.length());
            string = builder.toString();
        }
        return string;
    }

    private PersonalDataModel fromBriefcase(String surname, String name) {
        Briefcase b = this.cabinet.get(surname, name);
        if (b == null) {
            b = this.cabinet.get(name, surname);
        }
        Briefcase briefcase = b;
        return new Model(surname, name, briefcase);
    }

    private static class Model
    implements PersonalDataModel {
        private final String surname;
        private final String name;
        private final String ban;
        private final String can;
        private final String man;
        private final String dan;

        private Model(String surname, String name, ActNumber[] ban, ActNumber[] can, ActNumber[] man, ActNumber[] dan) {
            this.surname = surname;
            this.name = name;
            this.ban = Model.format(ban);
            this.can = Model.format(can);
            this.man = Model.format(man);
            this.dan = Model.format(dan);
        }

        private Model(String surname, String name, Briefcase briefcase) {
            this(surname, name, Model.normalize(briefcase, Briefcase::getBaptism), Model.normalize(briefcase, Briefcase::getConfirmation), Model.normalize(briefcase, Briefcase::getMarriage), Model.normalize(briefcase, Briefcase::getDecease));
        }

        @Override
        public String getSurname() {
            return this.surname;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getBaptismAN() {
            return this.ban;
        }

        @Override
        public String getConfirmationAN() {
            return this.can;
        }

        @Override
        public String getMarriageAN() {
            return this.man;
        }

        @Override
        public String getDeceaseAN() {
            return this.dan;
        }

        private static ActNumber[] normalize(Briefcase briefcase, Function<Briefcase, ActNumber[]> select) {
            return briefcase == null ? new ActNumber[]{} : select.apply(briefcase);
        }

        private static String format(ActNumber[] an) {
            return an.length == 0 ? "-" : (an.length == 1 ? an[0].toString() : Arrays.deepToString(an));
        }
    }
}

