/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import pl.koder95.eme.core.PersonalDataModelConverter;
import pl.koder95.eme.core.spi.FilingCabinet;
import pl.koder95.eme.core.spi.PersonalDataModel;

public class SuggestionProvider
implements Callback<AutoCompletionBinding.ISuggestionRequest, Collection<PersonalDataModel>> {
    private static final Comparator<PersonalDataModel> DEFAULT_COMPARATOR = Comparator.comparing(PersonalDataModel::getSurname).thenComparing(PersonalDataModel::getName);
    private final FilingCabinet cabinet;
    private final PersonalDataModelConverter defaultConverter;
    private StringConverter<PersonalDataModel> converter;
    private Comparator<PersonalDataModel> comparator;

    public SuggestionProvider(FilingCabinet cabinet, StringConverter<PersonalDataModel> converter, Comparator<PersonalDataModel> comparator) {
        this.cabinet = cabinet;
        this.defaultConverter = new PersonalDataModelConverter(cabinet);
        this.setConverter(converter);
        this.setComparator(comparator);
    }

    public SuggestionProvider(FilingCabinet cabinet, StringConverter<PersonalDataModel> converter) {
        this(cabinet, converter, null);
    }

    public SuggestionProvider(FilingCabinet cabinet) {
        this(cabinet, null);
    }

    public Collection<PersonalDataModel> call(AutoCompletionBinding.ISuggestionRequest param) {
        if (param.getUserText().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<PersonalDataModel> suggestions = new LinkedList<PersonalDataModel>();
        String string = param.getUserText().trim();
        int spaceIndex = string.indexOf(32);
        String beforeSpace = spaceIndex > -1 ? string.substring(0, spaceIndex) : string;
        String afterSpace = spaceIndex > -1 ? string.substring(spaceIndex + 1) : "";
        for (Map.Entry<String, Set<String>> entry : this.cabinet.getPersonalData().entrySet()) {
            String surname = entry.getKey();
            Set<String> names = entry.getValue();
            for (String name : names) {
                if (!this.accept(beforeSpace.toUpperCase(), afterSpace.toUpperCase(), surname.toUpperCase(), name.toUpperCase())) continue;
                this.addTo(suggestions, surname, name);
            }
        }
        suggestions.sort(this.comparator);
        ArrayList<PersonalDataModel> tmp = new ArrayList<PersonalDataModel>(suggestions);
        suggestions.clear();
        return tmp;
    }

    private void addTo(List<PersonalDataModel> suggestions, String surname, String name) {
        suggestions.add((PersonalDataModel)this.converter.fromString(surname + " " + name));
    }

    public boolean accept(String beforeSpace, String afterSpace, String surname, String name) {
        return afterSpace.isEmpty() ? surname.startsWith(beforeSpace) || name.startsWith(beforeSpace) : (surname.equals(beforeSpace) ? name.startsWith(afterSpace) : name.equals(beforeSpace) && surname.startsWith(afterSpace));
    }

    public FilingCabinet getCabinet() {
        return this.cabinet;
    }

    public StringConverter<PersonalDataModel> getConverter() {
        return this.converter;
    }

    public final void setConverter(StringConverter<PersonalDataModel> converter) {
        this.converter = converter != null ? converter : this.defaultConverter;
    }

    public Comparator<PersonalDataModel> getComparator() {
        return this.comparator;
    }

    public final void setComparator(Comparator<PersonalDataModel> comparator) {
        this.comparator = comparator != null ? comparator : DEFAULT_COMPARATOR;
    }
}

