/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.dfs;

import java.io.Serializable;
import java.util.regex.Matcher;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import pl.koder95.eme.Main;

public class ActNumber
implements Comparable<ActNumber>,
Serializable {
    private final ReadOnlyStringWrapper sign;
    private final ReadOnlyIntegerWrapper year;

    public ActNumber(String sign, int year) {
        this.sign = new ReadOnlyStringWrapper(sign);
        this.year = new ReadOnlyIntegerWrapper(year);
    }

    public String getSign() {
        return (String)this.signProperty().get();
    }

    public int getYear() {
        return this.yearProperty().get();
    }

    public String toString() {
        return this.getSign() + "/" + this.getYear();
    }

    @Override
    public int compareTo(ActNumber o) {
        if (this.getYear() > o.getYear()) {
            return 1;
        }
        if (this.getYear() < o.getYear()) {
            return -1;
        }
        Matcher digit1 = Main.DIGITS_STRING_PATTERN.matcher(this.getSign());
        Matcher digit2 = Main.DIGITS_STRING_PATTERN.matcher(o.getSign());
        if (digit1.find() && digit2.find()) {
            int act1 = Integer.parseInt(digit1.group(1));
            int act2 = Integer.parseInt(digit2.group(1));
            return Integer.compare(act1, act2);
        }
        String remainder1 = this.getSign().substring(digit1.end(1) + 1);
        String remainder2 = this.getSign().substring(digit2.end(1) + 1);
        return Main.DEFAULT_COLLATOR.compare(remainder1, remainder2);
    }

    public ReadOnlyStringProperty signProperty() {
        return this.sign.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty yearProperty() {
        return this.year.getReadOnlyProperty();
    }

    public static ActNumber parseActNumber(String s) {
        if (!s.contains("/")) {
            return null;
        }
        int slash = s.indexOf("/");
        if (slash == 0 || slash == s.length() - 1) {
            return null;
        }
        String sign = s.substring(0, slash);
        String yearS = s.substring(slash + 1);
        try {
            int year = Integer.parseInt(yearS);
            return new ActNumber(sign, year);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

