/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.dfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pl.koder95.eme.dfs.Index;
import pl.koder95.eme.xml.XMLLoader;

public class Book {
    final ObservableList<Index> indices;
    private final String name;

    public Book(String name) {
        this.name = name;
        this.indices = FXCollections.observableArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void load(NodeList indices) {
        if (indices == null) {
            return;
        }
        LinkedList<Index> linked = new LinkedList<Index>();
        for (int i = 0; i < indices.getLength(); ++i) {
            Index ix = Index.create(this, indices.item(i));
            if (ix == null) continue;
            linked.add(ix);
        }
        this.indices.addAll(linked);
        linked.clear();
    }

    public static Book load(Node book) {
        if (book == null) {
            return null;
        }
        if (book.getNodeName().equalsIgnoreCase("book")) {
            if (book.hasAttributes()) {
                Book b = new Book(XMLLoader.getAttrV(book, "name"));
                b.load(book.getChildNodes());
                return b;
            }
            return new Book("");
        }
        return null;
    }

    public static List<Book> load(File xml) throws IOException, ParserConfigurationException, SAXException {
        LinkedList<Book> books = new LinkedList<Book>();
        Document doc = XMLLoader.loadDOM(xml);
        Element indices = doc.getDocumentElement();
        if (indices.getNodeName().equalsIgnoreCase("indices")) {
            NodeList bookNodes = indices.getElementsByTagName("book");
            for (int i = 0; i < bookNodes.getLength(); ++i) {
                Book b = Book.load(bookNodes.item(i));
                if (b == null) continue;
                books.add(b);
            }
        }
        ArrayList<Book> array = new ArrayList<Book>(books);
        books.clear();
        return array;
    }
}

