/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.dfs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import pl.koder95.eme.Visited;
import pl.koder95.eme.dfs.ActNumber;
import pl.koder95.eme.dfs.Book;

public class Index
implements Visited {
    private final Map<String, String> data = new HashMap<String, String>();
    private ActNumber an;
    private final Book owner;

    private Index(Book owner, Node index) {
        this.owner = owner;
        NamedNodeMap attrs = index.getAttributes();
        while (attrs.getLength() > 0) {
            Node attr = attrs.item(0);
            String key = attr.getNodeName();
            String value = attr.getTextContent();
            this.data.put(key, value);
            attrs.removeNamedItem(key);
        }
    }

    private Index(Book owner) {
        this.owner = owner;
    }

    public static Index create(Node index) {
        return Index.create(null, index);
    }

    public static Index create(Book owner, Node index) {
        if (index == null) {
            return new Index(owner);
        }
        if (!index.getNodeName().equalsIgnoreCase("index")) {
            return null;
        }
        Index i = index.hasAttributes() ? new Index(owner, index) : new Index(owner);
        return i.getDataNames().contains("an") && !i.getData("an").isEmpty() ? i : null;
    }

    public String getData(String name) {
        return this.data.getOrDefault(name, "");
    }

    public Set<String> getDataNames() {
        return this.data.keySet();
    }

    public ActNumber getActNumber() {
        if (this.an == null) {
            this.an = ActNumber.parseActNumber(this.getData("an"));
        }
        return this.an;
    }

    public Book getOwner() {
        return this.owner;
    }

    public String toString() {
        return this.getActNumber() + " " + this.data.toString();
    }
}

