/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import pl.koder95.eme.Files;
import pl.koder95.eme.Main;
import pl.koder95.eme.MemoryUtils;
import pl.koder95.eme.dfs.Book;
import pl.koder95.eme.dfs.Index;
import pl.koder95.eme.dfs.IndexContainer;

public enum IndexList implements IndexContainer
{
    LIBER_BAPTISMORUM("Ksi\u0119ga ochrzczonych", new LinkedList<String>(Arrays.asList("name", "surname", "an"))),
    LIBER_CONFIRMATORUM("Ksi\u0119ga bierzmowanych", new LinkedList<String>(Arrays.asList("name", "surname", "an"))),
    LIBER_MATRIMONIORUM("Ksi\u0119ga za\u015blubionych", new LinkedList<String>(Arrays.asList("husband-surname", "husband-name", "wife-surname", "wife-name", "an"))),
    LIBER_DEFUNCTORUM("Ksi\u0119ga zmar\u0142ych", new LinkedList<String>(Arrays.asList("name", "surname", "an")));

    private List<Index> loaded = new LinkedList<Index>();
    private final String name;
    private final Queue<String> nameQueue;
    private static List<Book> BOOKS;

    private IndexList(String name, Queue<String> nameQueue) {
        this.name = name;
        this.nameQueue = nameQueue;
    }

    @Override
    public Index get(int id) {
        return this.loaded.get(id - 1);
    }

    @Override
    public List<Index> getLoaded() {
        return this.loaded;
    }

    public void load() {
        MemoryUtils.memory();
        this.loaded = new LinkedList<Index>();
        if (BOOKS == null) {
            IndexList.loadBooks();
        }
        BOOKS.stream().filter(b -> b.getName().equalsIgnoreCase(this.name)).forEach(b -> {
            MemoryUtils.memory();
            this.loaded.addAll((Collection<Index>)b.indices);
            MemoryUtils.memory();
            b.indices.forEach(i -> i.getDataNames().stream().filter(this.nameQueue::contains).forEachOrdered(this.nameQueue::add));
            MemoryUtils.memory();
        });
        List<Index> loaded = this.loaded;
        this.loaded = new ArrayList<Index>(loaded);
        loaded.clear();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.loaded.size();
    }

    @Override
    public Index getFirst() {
        return this.get(this.size());
    }

    public Index getNext(Index i) {
        int index = this.loaded.indexOf(i);
        return index < 0 ? null : this.loaded.get(index - 1);
    }

    public Index getPrev(Index i) {
        int index = this.loaded.indexOf(i);
        return index < this.loaded.size() ? this.loaded.get(index + 1) : null;
    }

    @Override
    public Index getLast() {
        return this.get(1);
    }

    @Override
    public void clear() {
        if (this.loaded == null) {
            return;
        }
        this.loaded.clear();
        Main.releaseMemory();
    }

    private static void loadBooks() {
        try {
            BOOKS = Book.load(Files.INDICES_XML.toFile());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            System.err.println(ex);
        }
    }
}

