/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.git;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.RateLimitHandler;
import pl.koder95.eme.Main;

public class GitHubRepositoryController {
    private GitHub connection = null;
    final String username;
    final String repositoryName;
    private GHUser user = null;
    private GHRepository repo = null;

    private GitHub createNewConnection() throws IOException {
        return new GitHubBuilder().withRateLimitHandler(new RateLimitHandler(){

            public void onError(IOException e, HttpURLConnection uc) {
                System.out.println(uc);
                e.printStackTrace();
            }
        }).build();
    }

    GitHub getConnection() {
        while (this.connection == null) {
            try {
                this.connection = this.createNewConnection();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.connection;
    }

    public GitHubRepositoryController(String username, String repositoryName) {
        this.username = username;
        this.repositoryName = repositoryName;
    }

    private void selectUser() throws IOException {
        GitHub connection = this.getConnection();
        if (connection.isOffline()) {
            this.connection = null;
            this.selectUser();
        } else {
            this.user = connection.getUser(this.username);
        }
    }

    private void selectRepository() throws IOException {
        if (this.user == null) {
            throw new IllegalStateException(Main.BUNDLE.getString("THR_USER_NOT_SELECTED"));
        }
        this.repo = this.user.getRepository(this.repositoryName);
    }

    public void init() {
        try {
            this.selectUser();
            this.selectRepository();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public GHRepository getRepository() {
        return this.repo;
    }
}

