/*
 * Decompiled with CFR 0.152.
 */
package pl.koder95.eme.git;

import java.io.IOException;
import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import pl.koder95.eme.Version;
import pl.koder95.eme.git.GitHubRepositoryController;

public final class RepositoryInfo {
    private static final RepositoryInfo INFO = new RepositoryInfo("eMetrykant", ".zip");
    private static final String DEFAULT_USER = "koder95";
    private final ReadOnlyObjectWrapper<Version> latestReleaseVersion = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<String> latestReleaseBrowserURL = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<Long> latestReleaseSize = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<String> latestReleaseName = new ReadOnlyObjectWrapper();
    private final String assetPrefix;
    private final String assetSuffix;

    public static RepositoryInfo get() {
        return INFO;
    }

    private RepositoryInfo(String assetPrefix, String assetSuffix) {
        this.assetPrefix = assetPrefix;
        this.assetSuffix = assetSuffix;
    }

    public Version getLatestReleaseVersion() {
        return (Version)this.latestReleaseVersionProperty().get();
    }

    public ReadOnlyObjectProperty<Version> latestReleaseVersionProperty() {
        return this.latestReleaseVersion.getReadOnlyProperty();
    }

    public String getLatestReleaseBrowserURL() {
        return (String)this.latestReleaseBrowserURLProperty().get();
    }

    public ReadOnlyObjectProperty<String> latestReleaseBrowserURLProperty() {
        return this.latestReleaseBrowserURL.getReadOnlyProperty();
    }

    public Long getLatestReleaseSize() {
        return (Long)this.latestReleaseSizeProperty().get();
    }

    public ReadOnlyObjectProperty<Long> latestReleaseSizeProperty() {
        return this.latestReleaseSize.getReadOnlyProperty();
    }

    public String getLatestReleaseName() {
        return (String)this.latestReleaseNameProperty().get();
    }

    public ReadOnlyObjectProperty<String> latestReleaseNameProperty() {
        return this.latestReleaseName.getReadOnlyProperty();
    }

    private void reload(String tagName, GHAsset latestZip) {
        this.latestReleaseBrowserURL.set((Object)latestZip.getBrowserDownloadUrl());
        this.latestReleaseVersion.set((Object)Version.parse(tagName));
        this.latestReleaseSize.set((Object)latestZip.getSize());
        this.latestReleaseName.set((Object)latestZip.getName());
    }

    private void reload(GHRelease latest) throws IOException {
        Optional<GHAsset> asset = latest.listAssets().toSet().stream().filter(a -> a.getName().startsWith(this.assetPrefix) && a.getName().endsWith(this.assetSuffix)).findAny();
        asset.ifPresent(ghAsset -> this.reload(latest.getTagName(), (GHAsset)ghAsset));
    }

    private void reload(GHRepository repository) throws IOException {
        GHRelease latest = repository.getLatestRelease();
        if (latest != null) {
            this.reload(latest);
        }
    }

    public void reload() throws IOException {
        GitHubRepositoryController controller = new GitHubRepositoryController(DEFAULT_USER, this.assetPrefix);
        controller.init();
        this.reload(controller.getRepository());
    }
}

