@file:Suppress("unused", "ClassName")

package pl.mareklangiewicz.kommand.gnome

import pl.mareklangiewicz.kground.*
import pl.mareklangiewicz.kommand.Kommand
import pl.mareklangiewicz.kommand.gnome.GnomeApp.Cmd
import pl.mareklangiewicz.kommand.gnome.GnomeApp.Cmd.Help

/** [gapplication ubuntu manpage](http://manpages.ubuntu.com/manpages/impish/man1/gapplication.1.html) */
fun gnomeapp(cmd: Cmd, init: GnomeApp.() -> Unit = {}) = GnomeApp(cmd).apply(init)

/** [gapplication ubuntu manpage](http://manpages.ubuntu.com/manpages/impish/man1/gapplication.1.html) */
data class GnomeApp(
  var cmd: Cmd = Help(),
  val addons: MutableList<String> = mutableListOf(),
) : Kommand {
  override val name get() = "gapplication"
  override val args get() = cmd.str + addons

  sealed class Cmd(val name: String, open val appid: String? = null, open val actid: String? = null) {

    open val str get() = listOf(name) plusIfNN appid plusIfNN actid

    /** Displays a short synopsis of the available commands or provides detailed help on a specific command. */
    data class Help(val cmdname: String? = null) : Cmd("help") {
      override val str get() = listOf(name) plusIfNN cmdname
    }

    /** Prints the GLib version whence gapplication came. */
    data object Version : Cmd("version")

    /**
     * Prints a list of all application IDs that are known to support D-Bus activation.
     * This list is generated by scanning .desktop files as per the current XDG_DATA_DIRS.
     */
    data object ListApps : Cmd("list-apps")

    /**
     * Launches an application.
     * The first parameter is the application ID in the familiar "reverse DNS" style (eg: 'org.gnome.app')
     * without the .desktop suffix. Optionally, if additional parameters are given,
     * they are treated as the names of files to open and may be filenames or URIs.
     * If no files are given then the application is simply activated.
     */
    data class Launch(override val appid: String) : Cmd("launch", appid)

    /**
     * List the actions declared in the application's .desktop file. The parameter is the application ID, as above.
     */
    data class ListActions(override val appid: String) : Cmd("list-actions", appid)

    /**
     * Invokes the named action
     * (in the same way as would occur when activating an action specified in the .desktop file).
     * The application ID (as above) is the first parameter. The action name follows.
     * Optionally, following the action name can be one parameter,
     * in GVariant format, given as a single argument. Make sure to use sufficient quoting.
     */
    data class Action(override val appid: String, override val actid: String) : Cmd("action", appid, actid)
  }

  operator fun String.unaryPlus() = addons.add(this)
}
