/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.hbase.common;

import akka.persistence.hbase.common.Columns$;
import akka.persistence.hbase.common.HBaseUtils;
import akka.persistence.hbase.common.RowKey;
import akka.persistence.hbase.common.SnapshotRowKey;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class HBaseUtils$class {
    public static Scan preparePartitionScan(HBaseUtils $this, byte[] table, byte[] family, RowKey startScanKey, RowKey stopScanKey, String persistenceIdRowRegex, boolean onlyRowKeys) {
        RowFilter rowFilter;
        Scan scan = new Scan();
        scan.setStartRow(startScanKey.toBytes());
        scan.setStopRow(stopScanKey.toBytes());
        scan.setBatch($this.hBasePersistenceSettings().scanBatchSize());
        if (onlyRowKeys) {
            FilterList fl = new FilterList(new Filter[0]);
            fl.addFilter((Filter)new FirstKeyOnlyFilter());
            fl.addFilter((Filter)new KeyOnlyFilter());
            fl.addFilter((Filter)new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(persistenceIdRowRegex)));
            rowFilter = fl;
        } else {
            scan.addColumn(family, Columns$.MODULE$.Marker());
            scan.addColumn(family, Columns$.MODULE$.Message());
            rowFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(persistenceIdRowRegex));
        }
        RowFilter filter = rowFilter;
        scan.setFilter((Filter)filter);
        return scan;
    }

    public static Scan preparePrefixScan(HBaseUtils $this, byte[] table, byte[] family, SnapshotRowKey startScanKey, SnapshotRowKey stopScanKey, String persistenceIdPrefix, boolean onlyRowKeys) {
        Scan scan = new Scan();
        scan.setStartRow(startScanKey.toBytes());
        scan.setStopRow(stopScanKey.toBytes());
        scan.setBatch($this.hBasePersistenceSettings().scanBatchSize());
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)persistenceIdPrefix)));
        return scan;
    }

    public static void $init$(HBaseUtils $this) {
    }
}

