/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.hbase.common;

import akka.persistence.hbase.common.RowKey;
import akka.persistence.hbase.journal.PersistencePluginSettings;
import org.apache.hadoop.hbase.util.Bytes;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.matching.Regex;

public final class RowKey$
implements Serializable {
    public static final RowKey$ MODULE$;
    private final Regex RowKeyPattern;

    static {
        new RowKey$();
    }

    public String patternForProcessor(String persistenceId, PersistencePluginSettings journalConfig) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".*-", "-.*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{persistenceId}));
    }

    public RowKey firstInPartition(String persistenceId, long partition, long fromSequenceNr, PersistencePluginSettings journalConfig) {
        Predef$.MODULE$.require(partition > 0L, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "partition must be > 0";
            }
        });
        Predef$.MODULE$.require(partition <= (long)journalConfig.partitionCount(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "partition must be <= partitionCount";
            }
        });
        long lowerBoundAdjustedSeqNr = partition < fromSequenceNr ? fromSequenceNr : this.selectPartition(partition, journalConfig);
        return new RowKey(this.selectPartition(partition, journalConfig), persistenceId, lowerBoundAdjustedSeqNr, journalConfig);
    }

    public long firstInPartition$default$3() {
        return 0L;
    }

    public RowKey lastInPartition(String persistenceId, long partition, long toSequenceNr, PersistencePluginSettings journalConfig) {
        Predef$.MODULE$.require(partition > 0L, (Function0)new Serializable(partition){
            public static final long serialVersionUID = 0L;
            private final long partition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition must be > 0, (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.partition$1)}));
            }
            {
                this.partition$1 = partition$1;
            }
        });
        Predef$.MODULE$.require(partition <= (long)journalConfig.partitionCount(), (Function0)new Serializable(partition, journalConfig){
            public static final long serialVersionUID = 0L;
            private final long partition$1;
            private final PersistencePluginSettings journalConfig$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition must be <= partitionCount, (", " <!= ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.partition$1), BoxesRunTime.boxToInteger((int)this.journalConfig$1.partitionCount())}));
            }
            {
                this.partition$1 = partition$1;
                this.journalConfig$1 = journalConfig$1;
            }
        });
        return new RowKey(this.selectPartition(partition, journalConfig), persistenceId, toSequenceNr, journalConfig);
    }

    public RowKey lastInPartition(String persistenceId, long partition, PersistencePluginSettings journalConfig) {
        Predef$.MODULE$.require(partition > 0L, (Function0)new Serializable(partition){
            public static final long serialVersionUID = 0L;
            private final long partition$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition must be > 0, (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.partition$2)}));
            }
            {
                this.partition$2 = partition$2;
            }
        });
        Predef$.MODULE$.require(partition <= (long)journalConfig.partitionCount(), (Function0)new Serializable(partition, journalConfig){
            public static final long serialVersionUID = 0L;
            private final long partition$2;
            private final PersistencePluginSettings journalConfig$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition must be <= partitionCount, (", " <!= ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.partition$2), BoxesRunTime.boxToInteger((int)this.journalConfig$2.partitionCount())}));
            }
            {
                this.partition$2 = partition$2;
                this.journalConfig$2 = journalConfig$2;
            }
        });
        return new RowKey(this.selectPartition(partition, journalConfig), persistenceId, this.lastSeqNrInPartition(partition, this.lastSeqNrInPartition$default$2()), journalConfig);
    }

    public long lastInPartition$default$3() {
        return Long.MAX_VALUE;
    }

    public RowKey firstForPersistenceId(String persistenceId, PersistencePluginSettings journalConfig) {
        return new RowKey(0L, persistenceId, 0L, journalConfig);
    }

    public RowKey lastForPersistenceId(String persistenceId, long toSequenceNr, PersistencePluginSettings journalConfig) {
        return this.lastInPartition(persistenceId, this.selectPartition(journalConfig.partitionCount(), journalConfig), toSequenceNr, journalConfig);
    }

    public long lastForPersistenceId$default$2() {
        return Long.MAX_VALUE;
    }

    public long selectPartition(long sequenceNr, PersistencePluginSettings journalConfig) {
        return sequenceNr % (long)journalConfig.partitionCount() == 0L ? (long)journalConfig.partitionCount() : sequenceNr % (long)journalConfig.partitionCount();
    }

    public Regex RowKeyPattern() {
        return this.RowKeyPattern;
    }

    public long extractSeqNr(byte[] rowKey) {
        byte[] num = (byte[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(rowKey).reverse()).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(byte x$1) {
                return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper((char)x$1));
            }
        })).reverse();
        return new StringOps(Predef$.MODULE$.augmentString(Bytes.toString((byte[])num))).toLong();
    }

    public long lastSeqNrInPartition(long p, long i) {
        while (i % p != 0L) {
            --i;
        }
        return i;
    }

    public long lastSeqNrInPartition$default$2() {
        return Long.MAX_VALUE;
    }

    public RowKey apply(long part, String persistenceId, long sequenceNr, PersistencePluginSettings hBasePersistenceSettings) {
        return new RowKey(part, persistenceId, sequenceNr, hBasePersistenceSettings);
    }

    public Option<Tuple3<Object, String, Object>> unapply(RowKey x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)x$0.part()), (Object)x$0.persistenceId(), (Object)BoxesRunTime.boxToLong((long)x$0.sequenceNr())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RowKey$() {
        MODULE$ = this;
        this.RowKeyPattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-.*-\\d")).r();
    }
}

