/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.hbase.journal;

import akka.actor.ActorRef;
import akka.actor.package$;
import akka.persistence.Delivered;
import akka.persistence.PersistentRepr;
import akka.persistence.hbase.common.Columns$;
import akka.persistence.hbase.common.RowKey;
import akka.persistence.hbase.common.RowKey$;
import akka.persistence.hbase.journal.HBaseAsyncRecovery$;
import akka.persistence.hbase.journal.HBaseAsyncWriteJournal;
import akka.persistence.hbase.journal.Resequencer;
import akka.persistence.hbase.journal.Resequencer$;
import akka.persistence.hbase.journal.RowTypeMarkers$;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.hbase.async.KeyValue;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

public abstract class HBaseAsyncRecovery$class {
    public static String akka$persistence$hbase$journal$HBaseAsyncRecovery$$replayDispatcherId(HBaseAsyncWriteJournal $this) {
        return $this.hBasePersistenceSettings().replayDispatcherId();
    }

    public static Future asyncReplayMessages(HBaseAsyncWriteJournal $this, String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Function1 replayCallback) {
        Future future;
        long l = max;
        if (0L == l) {
            $this.log().debug("Skipping async replay for persistenceId [{}], from sequenceNr: [{}], to sequenceNr: [{}], since max messages count to replay is 0", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr), (Object)BoxesRunTime.boxToLong((long)toSequenceNr));
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else {
            $this.log().debug("Async replay for persistenceId [{}], from sequenceNr: [{}], to sequenceNr: [{}]{}", (Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)fromSequenceNr), (Object)BoxesRunTime.boxToLong((long)toSequenceNr), (Object)(max != Long.MAX_VALUE ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", limited to: ", " messages"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)max)})) : ""));
            Promise reachedSeqNrPromise = Promise$.MODULE$.apply();
            AtomicBoolean loopedMaxFlag = new AtomicBoolean(false);
            ActorRef resequencer = $this.context().actorOf(Resequencer$.MODULE$.props(fromSequenceNr, max, (Function1<PersistentRepr, BoxedUnit>)replayCallback, loopedMaxFlag, (Promise<Object>)reachedSeqNrPromise, $this.akka$persistence$hbase$journal$HBaseAsyncRecovery$$replayDispatcherId()));
            int partitions = $this.hBasePersistenceSettings().partitionCount();
            IndexedSeq partitionScans = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitions).map((Function1)new Serializable($this, resequencer, persistenceId, fromSequenceNr, toSequenceNr, replayCallback){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseAsyncWriteJournal $outer;
                public final ActorRef resequencer$1;
                public final String persistenceId$1;
                public final long fromSequenceNr$1;
                public final long toSequenceNr$1;
                public final Function1 replayCallback$1;

                public final Future<Object> apply(int i) {
                    return Future$.MODULE$.apply((Function0)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseAsyncRecovery$.anonfun.2 $outer;
                        private final int i$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return HBaseAsyncRecovery$class.scanPartition$1(this.$outer.akka$persistence$hbase$journal$HBaseAsyncRecovery$$anonfun$$$outer(), this.i$1, this.$outer.resequencer$1, this.$outer.persistenceId$1, this.$outer.fromSequenceNr$1, this.$outer.toSequenceNr$1, this.$outer.replayCallback$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.i$1 = i$1;
                        }
                    }, (ExecutionContext)this.$outer.pluginDispatcher());
                }

                public /* synthetic */ HBaseAsyncWriteJournal akka$persistence$hbase$journal$HBaseAsyncRecovery$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.resequencer$1 = resequencer$1;
                    this.persistenceId$1 = persistenceId$1;
                    this.fromSequenceNr$1 = fromSequenceNr$1;
                    this.toSequenceNr$1 = toSequenceNr$1;
                    this.replayCallback$1 = replayCallback$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Future$.MODULE$.sequence((TraversableOnce)partitionScans, IndexedSeq$.MODULE$.canBuildFrom(), (ExecutionContext)$this.pluginDispatcher()).onSuccess((PartialFunction)new Serializable($this, resequencer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseAsyncWriteJournal $outer;
                private final ActorRef resequencer$1;

                public final <A1 extends IndexedSeq<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    BoxedUnit boxedUnit;
                    A1 A1 = x1;
                    List seqNrs = ((TraversableOnce)A1.filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$2) {
                            return this.apply$mcZJ$sp(x$2);
                        }

                        public boolean apply$mcZJ$sp(long x$2) {
                            return x$2 == 0L;
                        }
                    })).toList();
                    if (seqNrs.nonEmpty()) {
                        package$.MODULE$.actorRef2Scala(this.resequencer$1).$bang((Object)new Resequencer.AllPersistentsSubmitted(BoxesRunTime.unboxToLong((Object)seqNrs.min((Ordering)Ordering.Long$.MODULE$))), this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        package$.MODULE$.actorRef2Scala(this.resequencer$1).$bang((Object)new Resequencer.AllPersistentsSubmitted(0L), this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return (B1)boxedUnit2;
                }

                public final boolean isDefinedAt(IndexedSeq<Object> x1) {
                    IndexedSeq<Object> indexedSeq = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.resequencer$1 = resequencer$1;
                }
            }, (ExecutionContext)$this.pluginDispatcher());
            future = reachedSeqNrPromise.future().map((Function1)new Serializable($this, persistenceId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseAsyncWriteJournal $outer;
                private final String persistenceId$1;

                public final void apply(long x0$1) {
                    this.apply$mcVJ$sp(x0$1);
                }

                public void apply$mcVJ$sp(long x0$1) {
                    long l = x0$1;
                    this.$outer.log().debug("Completed recovery scanning for persistenceId {}", (Object)this.persistenceId$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.persistenceId$1 = persistenceId$1;
                }
            }, (ExecutionContext)$this.pluginDispatcher());
        }
        return future;
    }

    public static Future asyncReadHighestSequenceNr(HBaseAsyncWriteJournal $this, String persistenceId, long fromSequenceNr) {
        $this.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Async read for highest sequence number for persistenceId: [", "] (hint, seek from  nr: [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{persistenceId, BoxesRunTime.boxToLong((long)fromSequenceNr)})));
        int partitions = $this.hBasePersistenceSettings().partitionCount();
        IndexedSeq partitionScans = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), partitions).map((Function1)new Serializable($this, persistenceId, fromSequenceNr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseAsyncWriteJournal $outer;
            public final String persistenceId$2;
            public final long fromSequenceNr$2;

            public final Future<Object> apply(int i) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseAsyncRecovery$.anonfun.3 $outer;
                    private final int i$2;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return HBaseAsyncRecovery$class.scanPartitionForMaxSeqNr$1(this.$outer.akka$persistence$hbase$journal$HBaseAsyncRecovery$$anonfun$$$outer(), this.i$2, this.$outer.persistenceId$2, this.$outer.fromSequenceNr$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                }, (ExecutionContext)this.$outer.pluginDispatcher());
            }

            public /* synthetic */ HBaseAsyncWriteJournal akka$persistence$hbase$journal$HBaseAsyncRecovery$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.persistenceId$2 = persistenceId$2;
                this.fromSequenceNr$2 = fromSequenceNr$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)partitionScans, IndexedSeq$.MODULE$.canBuildFrom(), (ExecutionContext)$this.pluginDispatcher()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(IndexedSeq<Object> x0$2) {
                IndexedSeq<Object> indexedSeq = x0$2;
                long l = indexedSeq.isEmpty() ? 0L : BoxesRunTime.unboxToLong((Object)indexedSeq.max((Ordering)Ordering.Long$.MODULE$));
                return l;
            }
        }, (ExecutionContext)$this.pluginDispatcher()).map((Function1)new Serializable($this, persistenceId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseAsyncWriteJournal $outer;
            private final String persistenceId$2;

            public final long apply(long seqNr) {
                return this.apply$mcJJ$sp(seqNr);
            }

            public long apply$mcJJ$sp(long seqNr) {
                this.$outer.log().debug("Found highest seqNr for persistenceId: {}, it's: {}", (Object)this.persistenceId$2, (Object)BoxesRunTime.boxToLong((long)seqNr));
                return seqNr;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.persistenceId$2 = persistenceId$2;
            }
        }, (ExecutionContext)$this.pluginDispatcher());
    }

    private static long sequenceNr(HBaseAsyncWriteJournal $this, Buffer columns) {
        KeyValue messageKeyValue = $this.findColumn((Seq<KeyValue>)columns, Columns$.MODULE$.Message());
        PersistentRepr msg = $this.persistentFromBytes(messageKeyValue.value());
        return msg.sequenceNr();
    }

    private static final void resequenceMsg$1(HBaseAsyncWriteJournal $this, PersistentRepr persistentRepr, ActorRef resequencer$2, LongRef lowestSeqNr$1, long fromSequenceNr$1, long toSequenceNr$1) {
        long seqNr = persistentRepr.sequenceNr();
        if (fromSequenceNr$1 <= seqNr && seqNr <= toSequenceNr$1) {
            package$.MODULE$.actorRef2Scala(resequencer$2).$bang((Object)persistentRepr, $this.self());
            lowestSeqNr$1.elem = seqNr;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final long scanPartition$1(HBaseAsyncWriteJournal $this, long part, ActorRef resequencer, String persistenceId$1, long fromSequenceNr$1, long toSequenceNr$1, Function1 replayCallback$1) {
        void var14_11;
        void var15_12;
        long l;
        RowKey startScanKey = RowKey$.MODULE$.firstInPartition(persistenceId$1, part, fromSequenceNr$1, $this.hBasePersistenceSettings());
        RowKey stopScanKey = RowKey$.MODULE$.lastInPartition(persistenceId$1, part, toSequenceNr$1, $this.hBasePersistenceSettings());
        String persistenceIdRowRegex = RowKey$.MODULE$.patternForProcessor(persistenceId$1, $this.hBasePersistenceSettings());
        if (part > toSequenceNr$1) {
            return 0L;
        }
        $this.log().debug("Scanning {} partition for replay, from {} to {}", (Object)BoxesRunTime.boxToLong((long)part), (Object)startScanKey.toKeyString(), (Object)stopScanKey.toKeyString());
        Scan scan = $this.preparePartitionScan($this.tableBytes(), $this.familyBytes(), startScanKey, stopScanKey, persistenceIdRowRegex, false);
        ResultScanner scanner = $this.hTable().getScanner(scan);
        LongRef lowestSeqNr = LongRef.create((long)0L);
        try {
            Result res = scanner.next();
            while (true) {
                if (res != null) break block13;
                l = lowestSeqNr.elem;
                if (lowestSeqNr.elem <= 0L) break block14;
                break;
            }
        }
        catch (Throwable throwable) {
            if (var15_12.elem > 0L) {
                $this.log().debug("Done scheduling replays in partition {} (lowest seqNr: {})", (Object)BoxesRunTime.boxToLong((long)part), (Object)BoxesRunTime.boxToLong((long)var15_12.elem));
            }
            var14_11.close();
            throw throwable;
        }
        {
            Result result;
            block13: {
                block14: {
                    $this.log().debug("Done scheduling replays in partition {} (lowest seqNr: {})", (Object)BoxesRunTime.boxToLong((long)part), (Object)BoxesRunTime.boxToLong((long)lowestSeqNr.elem));
                }
                scanner.close();
                return l;
            }
            Cell markerCell = result.getColumnLatestCell($this.familyBytes(), Columns$.MODULE$.Marker());
            Cell messageCell = result.getColumnLatestCell($this.familyBytes(), Columns$.MODULE$.Message());
            if (markerCell != null && messageCell != null) {
                BoxedUnit boxedUnit;
                String marker = Bytes.toString((byte[])CellUtil.cloneValue((Cell)markerCell));
                String string = marker;
                if ("A".equals(string)) {
                    PersistentRepr persistentRepr = $this.persistentFromBytes(CellUtil.cloneValue((Cell)messageCell));
                    HBaseAsyncRecovery$class.resequenceMsg$1($this, persistentRepr, resequencer, (LongRef)var15_12, fromSequenceNr$1, toSequenceNr$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("S".equals(string)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("D".equals(string)) {
                    PersistentRepr persistentRepr = $this.persistentFromBytes(CellUtil.cloneValue((Cell)messageCell));
                    boolean x$3 = true;
                    long x$4 = persistentRepr.update$default$1();
                    String x$5 = persistentRepr.update$default$2();
                    int x$6 = persistentRepr.update$default$4();
                    scala.collection.immutable.Seq x$7 = persistentRepr.update$default$5();
                    Delivered x$8 = persistentRepr.update$default$6();
                    ActorRef x$9 = persistentRepr.update$default$7();
                    ActorRef x$10 = persistentRepr.update$default$8();
                    HBaseAsyncRecovery$class.resequenceMsg$1($this, persistentRepr.update(x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10), resequencer, (LongRef)var15_12, fromSequenceNr$1, toSequenceNr$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String channelId;
                    PersistentRepr persistentRepr = $this.persistentFromBytes(CellUtil.cloneValue((Cell)messageCell));
                    String string2 = channelId = RowTypeMarkers$.MODULE$.extractSeqNrFromConfirmedMarker(marker);
                    scala.collection.immutable.Seq x$11 = (scala.collection.immutable.Seq)persistentRepr.confirms().$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom());
                    long x$12 = persistentRepr.update$default$1();
                    String x$13 = persistentRepr.update$default$2();
                    boolean x$14 = persistentRepr.update$default$3();
                    int x$15 = persistentRepr.update$default$4();
                    Delivered x$16 = persistentRepr.update$default$6();
                    ActorRef x$17 = persistentRepr.update$default$7();
                    ActorRef x$18 = persistentRepr.update$default$8();
                    boxedUnit = (BoxedUnit)replayCallback$1.apply((Object)persistentRepr.update(x$12, x$13, x$14, x$15, x$11, x$16, x$17, x$18));
                }
            }
            result = var14_11.next();
            continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final long scanPartitionForMaxSeqNr$1(HBaseAsyncWriteJournal $this, long part, String persistenceId$2, long fromSequenceNr$2) {
        void var10_8;
        long l;
        long l2;
        RowKey startScanKey = RowKey$.MODULE$.firstInPartition(persistenceId$2, part, fromSequenceNr$2, $this.hBasePersistenceSettings());
        RowKey stopScanKey = RowKey$.MODULE$.lastInPartition(persistenceId$2, part, $this.hBasePersistenceSettings());
        String persistenceIdRowRegex = RowKey$.MODULE$.patternForProcessor(persistenceId$2, $this.hBasePersistenceSettings());
        Scan scan = $this.preparePartitionScan($this.tableBytes(), $this.familyBytes(), startScanKey, stopScanKey, persistenceIdRowRegex, true);
        ResultScanner scanner = $this.hTable().getScanner(scan);
        long highestSeqNr = 0L;
        try {
            Result res = scanner.next();
            while (true) {
                if (res != null) break block5;
                l2 = highestSeqNr;
                if (highestSeqNr <= 0L) break block6;
                break;
            }
        }
        catch (Throwable throwable) {
            if (l > 0L) {
                $this.log().debug("Done scheduling replays in partition {} (highest seqNr: {})", (Object)BoxesRunTime.boxToLong((long)part), (Object)BoxesRunTime.boxToLong((long)l));
            }
            var10_8.close();
            throw throwable;
        }
        {
            Result result;
            block5: {
                block6: {
                    $this.log().debug("Done scheduling replays in partition {} (highest seqNr: {})", (Object)BoxesRunTime.boxToLong((long)part), (Object)BoxesRunTime.boxToLong((long)highestSeqNr));
                }
                scanner.close();
                return l2;
            }
            long seqNr = RowKey$.MODULE$.extractSeqNr(result.getRow());
            l = scala.math.package$.MODULE$.max(l, seqNr);
            result = var10_8.next();
            continue;
        }
    }

    public static void $init$(HBaseAsyncWriteJournal $this) {
        $this.akka$persistence$hbase$journal$HBaseAsyncRecovery$_setter_$pluginDispatcher_$eq($this.context().system().dispatchers().lookup($this.akka$persistence$hbase$journal$HBaseAsyncRecovery$$replayDispatcherId()));
    }
}

