/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.hbase.journal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;

public final class HBaseJournalInit$ {
    public static final HBaseJournalInit$ MODULE$;

    static {
        new HBaseJournalInit$();
    }

    public boolean createTable(Config config) {
        Config journalConfig = config.getConfig("hbase-journal");
        String table = journalConfig.getString("table");
        String family = journalConfig.getString("family");
        return this.createTable(config, table, family);
    }

    /*
     * WARNING - void declaration
     */
    public boolean createTable(Config config, String table, String family) {
        boolean bl;
        Configuration conf = this.getHBaseConfig(config);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            bl = this.doInitTable(admin, table, family);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        admin.close();
        return bl;
    }

    public void disableTable(Config config) {
        Config journalConfig = config.getConfig("hbase-journal");
        String table = journalConfig.getString("table");
        this.disableTable(config, table);
    }

    /*
     * WARNING - void declaration
     */
    public void disableTable(Config config, String table) {
        Configuration conf = this.getHBaseConfig(config);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            admin.disableTable(table);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        admin.close();
    }

    public void deleteTable(Config config) {
        Config journalConfig = config.getConfig("hbase-journal");
        String table = journalConfig.getString("table");
        this.deleteTable(config, table);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteTable(Config config, String table) {
        Configuration conf = this.getHBaseConfig(config);
        HBaseAdmin admin = new HBaseAdmin(conf);
        try {
            admin.deleteTable(table);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        admin.close();
    }

    private boolean doInitTable(HBaseAdmin admin, String tableName, String familyName) {
        boolean bl;
        if (admin.tableExists(tableName)) {
            HTableDescriptor tableDesc = admin.getTableDescriptor(Bytes.toBytes((String)tableName));
            if (tableDesc.getFamily(Bytes.toBytes((String)familyName)) == null) {
                admin.addColumn(familyName, new HColumnDescriptor(familyName));
                bl = true;
            } else {
                bl = false;
            }
        } else {
            HTableDescriptor tableDesc = new HTableDescriptor(Bytes.toBytes((String)tableName));
            tableDesc.addFamily(new HColumnDescriptor(familyName));
            admin.createTable(tableDesc);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getHBaseConfig(Config config) {
        void var2_2;
        Configuration c = new Configuration();
        Config journalConfig = config.getConfig("hbase-journal");
        Config hbaseConfig = journalConfig.getConfig("hadoop-pass-through");
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(hbaseConfig.entrySet()).asScala()).foreach((Function1)new Serializable(c){
            public static final long serialVersionUID = 0L;
            private final Configuration c$1;

            public final void apply(Map.Entry<String, ConfigValue> e) {
                this.c$1.set(e.getKey(), e.getValue().unwrapped().toString());
            }
            {
                this.c$1 = c$1;
            }
        });
        return var2_2;
    }

    private HBaseJournalInit$() {
        MODULE$ = this;
    }
}

