/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.hbase.snapshot;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.ExtensionIdProvider;
import akka.persistence.PersistenceSettings;
import akka.persistence.hbase.journal.HBaseClientFactory$;
import akka.persistence.hbase.journal.HBaseJournalInit$;
import akka.persistence.hbase.journal.PersistencePluginSettings;
import akka.persistence.hbase.journal.PersistencePluginSettings$;
import akka.persistence.hbase.snapshot.HBaseSnapshotter;
import akka.persistence.hbase.snapshot.HadoopSnapshotter;
import akka.persistence.hbase.snapshot.HdfsSnapshotter;
import com.typesafe.config.Config;
import org.hbase.async.HBaseClient;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;

public final class HadoopSnapshotterExtension$
implements ExtensionId<HadoopSnapshotter>,
ExtensionIdProvider {
    public static final HadoopSnapshotterExtension$ MODULE$;
    private final String SnapshotStoreModeKey;

    static {
        new HadoopSnapshotterExtension$();
    }

    public Extension apply(ActorSystem system) {
        return ExtensionId.class.apply((ExtensionId)this, (ActorSystem)system);
    }

    public Extension get(ActorSystem system) {
        return ExtensionId.class.get((ExtensionId)this, (ActorSystem)system);
    }

    public final int hashCode() {
        return ExtensionId.class.hashCode((ExtensionId)this);
    }

    public final boolean equals(Object other) {
        return ExtensionId.class.equals((ExtensionId)this, (Object)other);
    }

    public String SnapshotStoreModeKey() {
        return this.SnapshotStoreModeKey;
    }

    public HadoopSnapshotterExtension$ lookup() {
        return this;
    }

    public HadoopSnapshotter createExtension(ExtendedActorSystem system) {
        String string;
        block4: {
            HadoopSnapshotter hadoopSnapshotter;
            block3: {
                PersistencePluginSettings pluginPersistenceSettings;
                block2: {
                    Config config = system.settings().config();
                    String mode = config.getString(this.SnapshotStoreModeKey());
                    pluginPersistenceSettings = PersistencePluginSettings$.MODULE$.apply(config);
                    PersistenceSettings persistenceSettings = new PersistenceSettings(config.getConfig("akka.persistence"));
                    HBaseClient client = HBaseClientFactory$.MODULE$.getClient(pluginPersistenceSettings, persistenceSettings);
                    string = mode;
                    if (!"hbase".equals(string)) break block2;
                    system.log().info("Using {} snapshotter implementation", (Object)HBaseSnapshotter.class.getCanonicalName());
                    HBaseJournalInit$.MODULE$.createTable(config, pluginPersistenceSettings.snapshotTable(), pluginPersistenceSettings.snapshotFamily());
                    hadoopSnapshotter = new HBaseSnapshotter((ActorSystem)system, pluginPersistenceSettings, client);
                    break block3;
                }
                if (!"hdfs".equals(string)) break block4;
                system.log().info("Using {} snapshotter implementation", (Object)HdfsSnapshotter.class.getCanonicalName());
                hadoopSnapshotter = new HdfsSnapshotter((ActorSystem)system, pluginPersistenceSettings);
            }
            return hadoopSnapshotter;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must be set to either ", " or ", "! Was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SnapshotStoreModeKey(), HBaseSnapshotter.class.getCanonicalName(), HdfsSnapshotter.class.getCanonicalName(), string})));
    }

    private HadoopSnapshotterExtension$() {
        MODULE$ = this;
        ExtensionId.class.$init$((ExtensionId)this);
        this.SnapshotStoreModeKey = "hadoop-snapshot-store.mode";
    }
}

