/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest
@kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u00068\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lpl/sparkbit/commons/test/cassandra/CassandraDaoTestBase;", "", "()V", "keyspace", "", "session", "Lcom/datastax/oss/driver/api/core/CqlSession;", "getSession", "()Lcom/datastax/oss/driver/api/core/CqlSession;", "setSession", "(Lcom/datastax/oss/driver/api/core/CqlSession;)V", "cleanupAfterTest", "", "sparkbit-test-commons"})
public class CassandraDaoTestBase {
    @Autowired
    protected CqlSession session;
    @Value(value="${cassandra-test.keyspace}")
    private String keyspace;

    @NotNull
    protected final CqlSession getSession() {
        CqlSession cqlSession = this.session;
        if (cqlSession != null) {
            return cqlSession;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        return null;
    }

    protected final void setSession(@NotNull CqlSession cqlSession) {
        Intrinsics.checkNotNullParameter((Object)cqlSession, (String)"<set-?>");
        this.session = cqlSession;
    }

    @After
    public final void cleanupAfterTest() {
        Metadata metadata = this.getSession().getMetadata();
        String string = this.keyspace;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyspace");
            string = null;
        }
        Collection tables = ((KeyspaceMetadata)metadata.getKeyspace(string).get()).getTables().values();
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableMetadata t = (TableMetadata)element$iv;
            boolean bl = false;
            this.getSession().execute("TRUNCATE " + t.getName());
        }
    }
}

