/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.cassandra;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.cassandra.config.AbstractCassandraConfiguration;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.ContainerState;
import pl.sparkbit.commons.test.cassandra.KCassandraContainer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u0004H\u0014J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0016\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0014J\b\u0010\u0010\u001a\u00020\u0004H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/sparkbit/commons/test/cassandra/CassandraTestConfigBase;", "Lorg/springframework/data/cassandra/config/AbstractCassandraConfiguration;", "()V", "basePackage", "", "cassandraImage", "initScripts", "", "[Ljava/lang/String;", "keyspace", "cassandraContainerState", "Lorg/testcontainers/containers/ContainerState;", "getContactPoints", "getEntityBasePackages", "()[Ljava/lang/String;", "getKeyspaceName", "getLocalDataCenter", "getPort", "", "getStartupScripts", "", "metersRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "prepareStartupScript", "", "text", "Companion", "sparkbit-test-commons"})
public class CassandraTestConfigBase
extends AbstractCassandraConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Value(value="${cassandra-test.image:cassandra:3.11}")
    @Nullable
    private final String cassandraImage;
    @Value(value="${cassandra-test.keyspace}")
    @Nullable
    private final String keyspace;
    @Value(value="${cassandra-test.base-package}")
    @Nullable
    private final String basePackage;
    @Value(value="${cassandra-test.init-scripts:}")
    @NotNull
    private final String[] initScripts;
    @NotNull
    private static final String TEST_CASSANDRA_IMAGE = "cassandra-test.image";
    @NotNull
    public static final String TEST_CASSANDRA_KEYSPACE = "cassandra-test.keyspace";
    @NotNull
    private static final String TEST_CASSANDRA_BASE_PACKAGE = "cassandra-test.base-package";
    @NotNull
    private static final String TEST_CASSANDRA_INIT_SCRIPTS = "cassandra-test.init-scripts";

    public CassandraTestConfigBase() {
        boolean $i$f$emptyArray = false;
        this.initScripts = (String[])((Object[])new String[0]);
    }

    @Bean
    @NotNull
    public ContainerState cassandraContainerState() {
        String string = this.cassandraImage;
        Intrinsics.checkNotNull((Object)string);
        KCassandraContainer cassandra = (KCassandraContainer)((KCassandraContainer)((KCassandraContainer)new KCassandraContainer(string).withInitScript("cassandra_keyspace.cql")).withTmpFs(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/var/lib/cassandra", (Object)"rw")))).withEnv("JVM_OPTS", "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Xmx384M -Xms384M");
        cassandra.start();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cassandra), (String)"cassandra");
        return (ContainerState)cassandra;
    }

    @NotNull
    protected String getContactPoints() {
        String string = this.cassandraContainerState().getContainerIpAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cassandraContainerState().containerIpAddress");
        return string;
    }

    protected int getPort() {
        ContainerState containerState = this.cassandraContainerState();
        Integer n = CassandraContainer.CQL_PORT;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"CQL_PORT");
        Integer n2 = containerState.getMappedPort(((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"cassandraContainerState(\u2026sandraContainer.CQL_PORT)");
        return ((Number)n2).intValue();
    }

    @Nullable
    protected String getKeyspaceName() {
        return this.keyspace;
    }

    @NotNull
    public String[] getEntityBasePackages() {
        String[] stringArray;
        if (this.basePackage != null) {
            String[] stringArray2 = new String[]{this.basePackage};
            stringArray = stringArray2;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @NotNull
    protected String getLocalDataCenter() {
        return "datacenter1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<String> getStartupScripts() {
        List result = new ArrayList();
        String[] $this$forEach$iv = this.initScripts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String script = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            InputStream inputStream = new ClassPathResource(script).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"ClassPathResource(script).inputStream");
            Closeable closeable = inputStream;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n2 = 8192;
            closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2);
            object = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl2 = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object text = object2;
            List<String> lines = this.prepareStartupScript((String)text);
            result.addAll((Collection)lines);
        }
        return result;
    }

    private final List<String> prepareStartupScript(String text) {
        return StringsKt.lines((CharSequence)CassandraTestConfigBase.prepareStartupScript$removeTrailingNewLine(CassandraTestConfigBase.prepareStartupScript$removeNewLineIfNotAfterSemicolon(CassandraTestConfigBase.prepareStartupScript$removeEmptyLines(text))));
    }

    @Bean
    @NotNull
    public MeterRegistry metersRegistry() {
        return (MeterRegistry)new SimpleMeterRegistry();
    }

    private static final String prepareStartupScript$removeEmptyLines(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("([\r\n])[\r\n]+");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    private static final String prepareStartupScript$removeNewLineIfNotAfterSemicolon(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("([^;])[\r\n]+");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    private static final String prepareStartupScript$removeTrailingNewLine(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("[\r\n]+$");
        String string = "";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lpl/sparkbit/commons/test/cassandra/CassandraTestConfigBase$Companion;", "", "()V", "TEST_CASSANDRA_BASE_PACKAGE", "", "TEST_CASSANDRA_IMAGE", "TEST_CASSANDRA_INIT_SCRIPTS", "TEST_CASSANDRA_KEYSPACE", "sparkbit-test-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

