/*
 * Decompiled with CFR 0.152.
 */
package pl.sparkbit.commons.test.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.testcontainers.containers.ContainerState;
import pl.sparkbit.commons.test.redis.RedisContainer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0017R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lpl/sparkbit/commons/test/redis/RedisTestConfigBase;", "", "()V", "redisExposedPort", "", "Ljava/lang/Integer;", "redisImage", "", "redisContainerState", "Lorg/testcontainers/containers/ContainerState;", "testConnectionFactory", "Lorg/springframework/data/redis/connection/RedisConnectionFactory;", "containerState", "Companion", "sparkbit-test-commons"})
public class RedisTestConfigBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Value(value="${redis-test.image:redis:5.0.8-alpine}")
    @Nullable
    private final String redisImage;
    @Value(value="${redis-test.exposed-port:6379}")
    @Nullable
    private final Integer redisExposedPort;
    @NotNull
    private static final String TEST_REDIS_IMAGE = "redis-test.image";
    @NotNull
    private static final String TEST_REDIS_EXPOSED_PORT = "redis-test.exposed-port";

    @Bean
    @NotNull
    public ContainerState redisContainerState() {
        String string = this.redisImage;
        Intrinsics.checkNotNull((Object)string);
        Integer[] integerArray = new Integer[]{this.redisExposedPort};
        RedisContainer redis = (RedisContainer)new RedisContainer(string).withExposedPorts(integerArray);
        redis.start();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)redis), (String)"redis");
        return (ContainerState)redis;
    }

    @Bean
    @NotNull
    public RedisConnectionFactory testConnectionFactory(@NotNull ContainerState containerState) {
        Intrinsics.checkNotNullParameter((Object)containerState, (String)"containerState");
        String string = containerState.getContainerIpAddress();
        Integer n = containerState.getFirstMappedPort();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"containerState.firstMappedPort");
        return (RedisConnectionFactory)new JedisConnectionFactory(new RedisStandaloneConfiguration(string, ((Number)n).intValue()));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpl/sparkbit/commons/test/redis/RedisTestConfigBase$Companion;", "", "()V", "TEST_REDIS_EXPOSED_PORT", "", "TEST_REDIS_IMAGE", "sparkbit-test-commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

