/**
 *   Copyright 2014 Symentis.pl
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package shelly.commands;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import shelly.api.Output;

/**
 * A command, you need to annotate it with {@link Description}
 * 
 * @author jaroslaw.palka@symentis.pl
 *
 */
public interface Command {

	/**
	 * 
	 * @author jaroslaw.palka@symentis.pl
	 *
	 */
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.TYPE, ElementType.METHOD })
	public @interface Description {
		String name();

		Option[] options() default {};

		String description() default "";
	}

	Output execute(Args args);

}
