/**
 *   Copyright 2014 Symentis.pl
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package shelly.commands;

/**
 * A way to define command line options/arguments for {@link Command}
 * 
 * @author jaroslaw.palka@symentis.pl
 *
 */
public @interface Option {

	/**
	 * Identification string of the Option
	 * 
	 * @return
	 */
	String opt();

	/**
	 * an alias and more descriptive identification string
	 * 
	 * @return
	 */
	String longOpt() default "";

	/**
	 * a description of the function of the option
	 * 
	 * @return
	 */
	String description() default "";

	/**
	 * a flag to say whether the option must appear on the command line.
	 * 
	 * @return
	 */
	boolean required() default false;

	/**
	 * a flag to say whether the option takes an argument
	 * 
	 * @return
	 */
	boolean arg() default false;

	int args() default 0; // a flag to say whether the option takes more
	                      // than one

	// argument

	int optionalArg() default 0;// a flag to say whether the option's
	                            // argument is

	// optional

	String argName() default "";// the name of the argument value for the usage
	                            // statement

	char valueSeparator() default ',';// char the character value used to split
	                                  // the argument

	// string, that is used in conjunction with
	// multipleArgs e.g. if the separator is ',' and the
	// argument string is 'a,b,c' then there are three
	// argument values, 'a', 'b' and 'c'.

	Class<?> type() default String.class;// java.lang.Object the type of the
	                                     // argument

}
