/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.process;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import com.typesafe.config.Config;
import pl.touk.nussknacker.engine.CustomProcessValidator;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u000514AAB\u0004\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0004-\u0001\t\u0007I\u0011B\u0017\t\rY\u0002\u0001\u0015!\u0003/\u0011\u00159\u0004\u0001\"\u00019\u0005i1E.\u001b8l'\u000e,g.\u0019:j_:\u000bW.\u001a,bY&$\u0017\r^8s\u0015\tA\u0011\"A\u0004qe>\u001cWm]:\u000b\u0005)Y\u0011AB3oO&tWM\u0003\u0002\r\u001b\u0005Ya.^:tW:\f7m[3s\u0015\tqq\"\u0001\u0003u_V\\'\"\u0001\t\u0002\u0005Ad7\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\t\u0011\"\u0003\u0002\u001d\u0013\t12)^:u_6\u0004&o\\2fgN4\u0016\r\\5eCR|'/\u0001\u0004d_:4\u0017n\u001a\t\u0003?\u0015j\u0011\u0001\t\u0006\u0003;\u0005R!AI\u0012\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001J\u0001\u0004G>l\u0017B\u0001\u0014!\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"!K\u0016\u0011\u0005)\u0002Q\"A\u0004\t\u000bu\u0011\u0001\u0019\u0001\u0010\u0002C\u0019d\u0017N\\6Qe>\u001cWm]:OC6,g+\u00197jI\u0006$\u0018n\u001c8QCR$XM\u001d8\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u00115\fGo\u00195j]\u001eT!aM\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003kA\u0012QAU3hKb\f!E\u001a7j].\u0004&o\\2fgNt\u0015-\\3WC2LG-\u0019;j_:\u0004\u0016\r\u001e;fe:\u0004\u0013\u0001\u0003<bY&$\u0017\r^3\u0015\u0005e*\u0007\u0003\u0002\u001eI\u0017\nt!aO#\u000f\u0005q\u0012eBA\u001fA\u001b\u0005q$BA \u0012\u0003\u0019a$o\\8u}%\t\u0011)\u0001\u0003dCR\u001c\u0018BA\"E\u0003\u0011!\u0017\r^1\u000b\u0003\u0005K!AR$\u0002\u000fA\f7m[1hK*\u00111\tR\u0005\u0003\u0013*\u0013ABV1mS\u0012\fG/\u001a3OK2T!AR$\u0011\u00051{fBA']\u001d\tq\u0015L\u0004\u0002P/:\u0011\u0001K\u0016\b\u0003#Vs!A\u0015+\u000f\u0005u\u001a\u0016\"\u0001\t\n\u00059y\u0011B\u0001\u0007\u000e\u0013\tQ1\"\u0003\u0002Y\u0013\u0005\u0019\u0011\r]5\n\u0005i[\u0016aB2p]R,\u0007\u0010\u001e\u0006\u00031&I!!\u00180\u0002/A\u0013xnY3tg\u000e{W\u000e]5mCRLwN\\#se>\u0014(B\u0001.\\\u0013\t\u0001\u0017MA\u000eTG\u0016t\u0017M]5p\u001d\u0006lWMV1mS\u0012\fG/[8o\u000bJ\u0014xN\u001d\u0006\u0003;z\u0003\"\u0001F2\n\u0005\u0011,\"\u0001B+oSRDQ\u0001C\u0003A\u0002\u0019\u0004\"a\u001a6\u000e\u0003!T!![\u0005\u0002\u001d\r\fgn\u001c8jG\u0006dwM]1qQ&\u00111\u000e\u001b\u0002\u0011\u0007\u0006twN\\5dC2\u0004&o\\2fgN\u0004")
public class FlinkScenarioNameValidator
implements CustomProcessValidator {
    private final Regex flinkProcessNameValidationPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[a-zA-Z0-9_-]++[a-zA-Z0-9_ -]*+(?<! )"));

    private Regex flinkProcessNameValidationPattern() {
        return this.flinkProcessNameValidationPattern;
    }

    public Validated<NonEmptyList<ProcessCompilationError.ScenarioNameValidationError>, BoxedUnit> validate(CanonicalProcess process) {
        String scenarioName = process.metaData().id();
        if (this.flinkProcessNameValidationPattern().pattern().matcher(scenarioName).matches()) {
            return new Validated.Valid((Object)BoxedUnit.UNIT);
        }
        return new Validated.Invalid((Object)NonEmptyList$.MODULE$.one((Object)new ProcessCompilationError.ScenarioNameValidationError("Invalid scenario name " + scenarioName + ". Only digits, letters, underscore (_), hyphen (-) and space in the middle are allowed", "Provided scenario name is invalid for this category. Please enter valid name using only specified characters.")));
    }

    public FlinkScenarioNameValidator(Config config) {
    }
}

