/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.sttp;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.sttp.HttpClientError;
import pl.touk.nussknacker.engine.sttp.HttpClientErrorHandler$HttpErrorExtractor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client3.HttpError;
import sttp.client3.Response;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;

public final class HttpClientErrorHandler$
implements LazyLogging {
    public static final HttpClientErrorHandler$ MODULE$ = new HttpClientErrorHandler$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        HttpClientErrorHandler$ httpClientErrorHandler$ = this;
        synchronized (httpClientErrorHandler$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public Future<BoxedUnit> handleUnitResponse(String action, Option<String> message, Response<Either<String, String>> response) {
        Tuple2 tuple2 = new Tuple2((Object)new StatusCode(response.code()), response.body());
        if (tuple2 != null) {
            int code = ((StatusCode)tuple2._1()).code();
            Either either = (Either)tuple2._2();
            if (either instanceof Right && StatusCode$.MODULE$.isSuccess$extension(code)) {
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        if (tuple2 != null) {
            int code = ((StatusCode)tuple2._1()).code();
            Either either = (Either)tuple2._2();
            if (either instanceof Right) {
                Right right = (Right)either;
                String body = (String)right.value();
                return this.pl$touk$nussknacker$engine$sttp$HttpClientErrorHandler$$handleClientError(body, code, action, message);
            }
        }
        if (tuple2 != null) {
            int code = ((StatusCode)tuple2._1()).code();
            Either either = (Either)tuple2._2();
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                return this.pl$touk$nussknacker$engine$sttp$HttpClientErrorHandler$$handleClientError(error, code, action, message);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<String> handleUnitResponse$default$2() {
        return None$.MODULE$;
    }

    public <T> PartialFunction<Throwable, Future<T>> recoverWithMessage(String action, Option<String> message) {
        return new Serializable(action, message){
            private static final long serialVersionUID = 0L;
            private final String action$1;
            private final Option message$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HttpError httpError;
                Option<HttpError<?>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = HttpClientErrorHandler$HttpErrorExtractor$.MODULE$.unapply(A1)).isEmpty() && (httpError = (HttpError)option.get()) instanceof HttpError) {
                    HttpError httpError2 = httpError;
                    Object body = httpError2.body();
                    int status = httpError2.statusCode();
                    return (B1)HttpClientErrorHandler$.MODULE$.pl$touk$nussknacker$engine$sttp$HttpClientErrorHandler$$handleClientError(String.valueOf(body), status, this.action$1, (Option<String>)this.message$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                HttpError httpError;
                Option<HttpError<?>> option;
                Throwable throwable = x1;
                return throwable != null && !(option = HttpClientErrorHandler$HttpErrorExtractor$.MODULE$.unapply(throwable)).isEmpty() && (httpError = (HttpError)option.get()) instanceof HttpError;
            }
            {
                this.action$1 = action$1;
                this.message$1 = message$1;
            }
        };
    }

    public <T> Option<String> recoverWithMessage$default$2() {
        return None$.MODULE$;
    }

    public Future<Nothing$> pl$touk$nussknacker$engine$sttp$HttpClientErrorHandler$$handleClientError(String body, int status, String action, Option<String> message) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Failed to {}, status code: {}, errors: {}.", new Object[]{action, new StatusCode(status), body});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String errorMessage = (String)message.getOrElse((Function0 & Serializable)() -> "Failed to " + action + ". Detailed error information in logs.");
        return Future$.MODULE$.failed((Throwable)new HttpClientError(errorMessage));
    }

    private HttpClientErrorHandler$() {
    }
}

