/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.json;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import java.io.Serializable;
import org.everit.json.schema.Schema;
import pl.touk.nussknacker.engine.api.MetaData;
import pl.touk.nussknacker.engine.api.NodeId;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.api.context.transformation.NodeDependencyValue;
import pl.touk.nussknacker.engine.api.definition.TypedNodeDependency$;
import pl.touk.nussknacker.engine.json.JsonSchemaBuilder$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00194A\u0001B\u0003\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)1\u0004\u0001C\u0001'\n\u0019\"j]8o'\u000eDW-\\1FqR\u0014\u0018m\u0019;pe*\u0011aaB\u0001\u0005UN|gN\u0003\u0002\t\u0013\u00051QM\\4j]\u0016T!AC\u0006\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003\u00195\tA\u0001^8vW*\ta\"\u0001\u0002qY\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011!B\u0001\u0016O\u0016$8k\u00195f[\u00064%o\\7Qe>\u0004XM\u001d;z)\u0011i2\b\u0013(\u0011\ty\u0019S\u0005M\u0007\u0002?)\u0011\u0001%I\u0001\u0005I\u0006$\u0018MC\u0001#\u0003\u0011\u0019\u0017\r^:\n\u0005\u0011z\"!\u0003,bY&$\u0017\r^3e!\rqb\u0005K\u0005\u0003O}\u0011ABT8o\u000b6\u0004H/\u001f'jgR\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000f\r|g\u000e^3yi*\u0011QfB\u0001\u0004CBL\u0017BA\u0018+\u0005]\u0001&o\\2fgN\u001cu.\u001c9jY\u0006$\u0018n\u001c8FeJ|'\u000f\u0005\u00022s5\t!G\u0003\u00024i\u000511o\u00195f[\u0006T!AB\u001b\u000b\u0005Y:\u0014AB3wKJLGOC\u00019\u0003\ry'oZ\u0005\u0003uI\u0012aaU2iK6\f\u0007\"\u0002\u001f\u0003\u0001\u0004i\u0014\u0001\u00039s_B,'\u000f^=\u0011\u0005y*eBA D!\t\u00015#D\u0001B\u0015\t\u0011u\"\u0001\u0004=e>|GOP\u0005\u0003\tN\ta\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011Ai\u0005\u0005\u0006\u0013\n\u0001\rAS\u0001\t[\u0016$\u0018\rR1uCB\u00111\nT\u0007\u0002Y%\u0011Q\n\f\u0002\t\u001b\u0016$\u0018\rR1uC\")qJ\u0001a\u0001!\u00061an\u001c3f\u0013\u0012\u0004\"aS)\n\u0005Ic#A\u0002(pI\u0016LE\rF\u0002\u001e)VCQ\u0001P\u0002A\u0002uBQAV\u0002A\u0002]\u000bA\u0002Z3qK:$WM\\2jKN\u00042\u0001W/a\u001d\tI6L\u0004\u0002A5&\tA#\u0003\u0002]'\u00059\u0001/Y2lC\u001e,\u0017B\u00010`\u0005\u0011a\u0015n\u001d;\u000b\u0005q\u001b\u0002CA1e\u001b\u0005\u0011'BA2+\u00039!(/\u00198tM>\u0014X.\u0019;j_:L!!\u001a2\u0003'9{G-\u001a#fa\u0016tG-\u001a8dsZ\u000bG.^3")
public class JsonSchemaExtractor {
    public Validated<NonEmptyList<ProcessCompilationError>, Schema> getSchemaFromProperty(String property, MetaData metaData, NodeId nodeId) {
        return (Validated)metaData.additionalFields().properties().get((Object)property).map((Function1 & Serializable)rawSchema -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> JsonSchemaBuilder$.MODULE$.parseSchema((String)rawSchema));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Schema schema = (Schema)success.value();
                return new Validated.Valid((Object)schema);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exc = failure.exception();
                return JsonSchemaExtractor.invalid$1("Error at parsing \"" + property + "\": " + exc.getMessage() + ".", nodeId);
            }
            throw new MatchError((Object)try_);
        }).getOrElse((Function0 & Serializable)() -> JsonSchemaExtractor.invalid$1("Missing \"" + property + "\" property.", nodeId));
    }

    public Validated<NonEmptyList<ProcessCompilationError>, Schema> getSchemaFromProperty(String property, List<NodeDependencyValue> dependencies) {
        MetaData metaData = (MetaData)TypedNodeDependency$.MODULE$.apply(ClassTag$.MODULE$.apply(MetaData.class)).extract(dependencies);
        NodeId nodeId = (NodeId)TypedNodeDependency$.MODULE$.apply(ClassTag$.MODULE$.apply(NodeId.class)).extract(dependencies);
        return this.getSchemaFromProperty(property, metaData, nodeId);
    }

    private static final Validated.Invalid invalid$1(String message, NodeId nodeId$1) {
        return new Validated.Invalid((Object)NonEmptyList$.MODULE$.one((Object)ProcessCompilationError.CustomNodeError$.MODULE$.apply(message, (Option)None$.MODULE$, nodeId$1)));
    }
}

