/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Encoder;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Headers;
import pl.touk.nussknacker.engine.kafka.ConsumerRecordHelper$;
import pl.touk.nussknacker.engine.kafka.KafkaConfig;
import pl.touk.nussknacker.engine.kafka.KafkaConfig$;
import pl.touk.nussknacker.engine.kafka.KafkaRecordUtils$;
import pl.touk.nussknacker.engine.kafka.KafkaTestUtils$;
import pl.touk.nussknacker.engine.kafka.KafkaUtils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t}e\u0001\u0002\u0013&\u0001AB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0005\")a\n\u0001C\u0001\u001f\"9A\u000b\u0001b\u0001\n\u0013)\u0006BB5\u0001A\u0003%a\u000bC\u0004Z\u0001\t\u0007I\u0011\u00026\t\r1\u0004\u0001\u0015!\u0003l\u0011\u001di\u0007A1A\u0005\n9Da! \u0001!\u0002\u0013y\u0007\u0002\u0003@\u0001\u0011\u000b\u0007I\u0011B@\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002V\u0001!\t!!\u001d\t\u0013\u0005%\u0006!%A\u0005\u0002\u0005-\u0006\"CAX\u0001E\u0005I\u0011AAY\u0011%\t)\fAI\u0001\n\u0003\t9\fC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005m\u0006\u0001\"\u0001\u0002r\"I!Q\u0002\u0001\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005'\u0001\u0011\u0013!C\u0001\u0005+A\u0011B!\u0007\u0001#\u0003%\tAa\u0007\t\u000f\t}\u0001\u0001\"\u0001\u0003\"!I!\u0011\u0006\u0001\u0012\u0002\u0013\u0005!1\u0006\u0005\b\u0005_\u0001A\u0011\u0002B\u0019\u0011%\u0011\u0019\u0006AI\u0001\n\u0013\u0011)\u0006C\u0005\u0003\\\u0001\t\n\u0011\"\u0003\u0003^!I!1\r\u0001\u0012\u0002\u0013%!Q\r\u0005\b\u0005W\u0002A\u0011\u0002B7\u0011\u001d\u0011Y\u0007\u0001C\u0005\u0005\u007fBqAa&\u0001\t\u0003\u0011I\nC\u0004\u0003\u001c\u0002!\tA!'\t\u000f\tu\u0005\u0001\"\u0001\u0003\u001a\nY1*\u00194lC\u000ec\u0017.\u001a8u\u0015\t1s%A\u0003lC\u001a\\\u0017M\u0003\u0002)S\u00051QM\\4j]\u0016T!AK\u0016\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003Y5\nA\u0001^8vW*\ta&\u0001\u0002qY\u000e\u00011c\u0001\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O \u000e\u0003eR!AO\u001e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005qj\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003y\n1aY8n\u0013\t\u0001\u0015HA\u0006MCjLHj\\4hS:<\u0017\u0001D6bM.\f\u0017\t\u001a3sKN\u001c\bCA\"K\u001d\t!\u0005\n\u0005\u0002Fg5\taI\u0003\u0002H_\u00051AH]8pizJ!!S\u001a\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013N\n!!\u001b3\u0002\rqJg.\u001b;?)\r\u0001&k\u0015\t\u0003#\u0002i\u0011!\n\u0005\u0006\u0003\u000e\u0001\rA\u0011\u0005\u0006\u001b\u000e\u0001\rAQ\u0001\fe\u0006<\bK]8ek\u000e,'/F\u0001W!\u00119\u0016mY2\u000e\u0003aS!!\u0017.\u0002\u0011A\u0014x\u000eZ;dKJT!a\u0017/\u0002\u000f\rd\u0017.\u001a8ug*\u0011a%\u0018\u0006\u0003=~\u000ba!\u00199bG\",'\"\u00011\u0002\u0007=\u0014x-\u0003\u0002c1\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u00042A\r3g\u0013\t)7GA\u0003BeJ\f\u0017\u0010\u0005\u00023O&\u0011\u0001n\r\u0002\u0005\u0005f$X-\u0001\u0007sC^\u0004&o\u001c3vG\u0016\u0014\b%F\u0001l!\u00119\u0016M\u0011\"\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013!C2p]N,X.\u001a:t+\u0005y\u0007c\u00019vo6\t\u0011O\u0003\u0002sg\u00069Q.\u001e;bE2,'B\u0001;4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mF\u0014q\u0001S1tQN+G\u000f\u0005\u0003yw\u000e\u001cW\"A=\u000b\u0005iT\u0016\u0001C2p]N,X.\u001a:\n\u0005qL(!D&bM.\f7i\u001c8tk6,'/\u0001\u0006d_:\u001cX/\\3sg\u0002\n1\"\u00193nS:\u001cE.[3oiV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001.\u0002\u000b\u0005$W.\u001b8\n\t\u0005-\u0011Q\u0001\u0002\u0006\u0003\u0012l\u0017N\\\u0001\fGJ,\u0017\r^3U_BL7\r\u0006\u0004\u0002\u0012\u0005]\u00111\u0004\t\u0004e\u0005M\u0011bAA\u000bg\t!QK\\5u\u0011\u0019\tIb\u0003a\u0001\u0005\u0006!a.Y7f\u0011%\tib\u0003I\u0001\u0002\u0004\ty\"\u0001\u0006qCJ$\u0018\u000e^5p]N\u00042AMA\u0011\u0013\r\t\u0019c\r\u0002\u0004\u0013:$\u0018!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$HEM\u000b\u0003\u0003SQC!a\b\u0002,-\u0012\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00028M\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY$!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006eK2,G/\u001a+pa&\u001cG\u0003BA\t\u0003\u0003Ba!!\u0007\u000e\u0001\u0004\u0011\u0015!\u0002;pa&\u001cG\u0003BA$\u0003'\u0002RAMA%\u0003\u001bJ1!a\u00134\u0005\u0019y\u0005\u000f^5p]B!\u00111AA(\u0013\u0011\t\t&!\u0002\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007BBA\r\u001d\u0001\u0007!)\u0001\btK:$'+Y<NKN\u001c\u0018mZ3\u0015\r\u0005e\u00131NA7!\u0019\tY&!\u0019\u0002f5\u0011\u0011Q\f\u0006\u0004\u0003?\u001a\u0014AC2p]\u000e,(O]3oi&!\u00111MA/\u0005\u00191U\u000f^;sKB\u0019q+a\u001a\n\u0007\u0005%\u0004L\u0001\bSK\u000e|'\u000fZ'fi\u0006$\u0017\r^1\t\r\u0005\rs\u00021\u0001C\u0011\u0019\tyg\u0004a\u0001G\u000691m\u001c8uK:$HCDA-\u0003g\n)(!\u001f\u0002|\u0005\u0005\u0015Q\u0013\u0005\u0007\u0003\u0007\u0002\u0002\u0019\u0001\"\t\r\u0005]\u0004\u00031\u0001d\u0003\rYW-\u001f\u0005\u0007\u0003_\u0002\u0002\u0019A2\t\u0013\u0005u\u0004\u0003%AA\u0002\u0005}\u0014!\u00039beRLG/[8o!\u0015\u0011\u0014\u0011JA\u0010\u0011%\t\u0019\t\u0005I\u0001\u0002\u0004\t))A\u0005uS6,7\u000f^1naB!\u0011qQAI\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015\u0001\u00027b]\u001eT!!a$\u0002\t)\fg/Y\u0005\u0005\u0003'\u000bII\u0001\u0003M_:<\u0007\"CAL!A\u0005\t\u0019AAM\u0003\u001dAW-\u00193feN\u0004B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0004iK\u0006$WM\u001d\u0006\u0004\u0003Gc\u0016AB2p[6|g.\u0003\u0003\u0002(\u0006u%a\u0002%fC\u0012,'o]\u0001\u0019g\u0016tGMU1x\u001b\u0016\u001c8/Y4fI\u0011,g-Y;mi\u0012\"TCAAWU\u0011\ty(a\u000b\u00021M,g\u000e\u001a*bo6+7o]1hK\u0012\"WMZ1vYR$S'\u0006\u0002\u00024*\"\u0011QQA\u0016\u0003a\u0019XM\u001c3SC^lUm]:bO\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0003sSC!!'\u0002,\u0005Y1/\u001a8e\u001b\u0016\u001c8/Y4f+\u0011\ty,a7\u0015\r\u0005\u0005\u0017Q^Ax)\u0011\tI&a1\t\u0013\u0005\u0015G#!AA\u0004\u0005\u001d\u0017AC3wS\u0012,gnY3%cA1\u0011\u0011ZAj\u0003/l!!a3\u000b\t\u00055\u0017qZ\u0001\u0006G&\u00148-\u001a\u0006\u0003\u0003#\f!![8\n\t\u0005U\u00171\u001a\u0002\b\u000b:\u001cw\u000eZ3s!\u0011\tI.a7\r\u0001\u00119\u0011Q\u001c\u000bC\u0002\u0005}'!\u0001+\u0012\t\u0005\u0005\u0018q\u001d\t\u0004e\u0005\r\u0018bAAsg\t9aj\u001c;iS:<\u0007c\u0001\u001a\u0002j&\u0019\u00111^\u001a\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002DQ\u0001\rA\u0011\u0005\b\u0003_\"\u0002\u0019AAl+\u0011\t\u00190a@\u0015\u001d\u0005U(\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\u0003\fQ!\u0011\u0011LA|\u0011%\tI0FA\u0001\u0002\b\tY0\u0001\u0006fm&$WM\\2fII\u0002b!!3\u0002T\u0006u\b\u0003BAm\u0003\u007f$q!!8\u0016\u0005\u0004\ty\u000e\u0003\u0004\u0002DU\u0001\rA\u0011\u0005\u0007\u0003o*\u0002\u0019\u0001\"\t\u000f\u0005=T\u00031\u0001\u0002~\"I\u0011QP\u000b\u0011\u0002\u0003\u0007\u0011q\u0010\u0005\n\u0003\u0007+\u0002\u0013!a\u0001\u0003\u000bC\u0011\"a&\u0016!\u0003\u0005\r!!'\u0002+M,g\u000eZ'fgN\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%iU!\u00111\u0016B\t\t\u001d\tiN\u0006b\u0001\u0003?\fQc]3oI6+7o]1hK\u0012\"WMZ1vYR$S'\u0006\u0003\u00022\n]AaBAo/\t\u0007\u0011q\\\u0001\u0016g\u0016tG-T3tg\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00137+\u0011\t9L!\b\u0005\u000f\u0005u\u0007D1\u0001\u0002`\u0006q1M]3bi\u0016\u001cuN\\:v[\u0016\u0014HcA<\u0003$!I!QE\r\u0011\u0002\u0003\u0007!qE\u0001\u000bOJ|W\u000f]%e\u001fB$\b\u0003\u0002\u001a\u0002J\t\u000b\u0001d\u0019:fCR,7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iC\u000b\u0003\u0003(\u0005-\u0012\u0001D2sK\u0006$XMU3d_J$WC\u0002B\u001a\u0005{\u0011\u0019\u0005\u0006\b\u00036\t\u001d#\u0011\nB&\u0005\u001b\u0012yE!\u0015\u0011\u000f]\u00139Da\u000f\u0003B%\u0019!\u0011\b-\u0003\u001dA\u0013x\u000eZ;dKJ\u0014VmY8sIB!\u0011\u0011\u001cB\u001f\t\u001d\u0011yd\u0007b\u0001\u0003?\u0014\u0011a\u0013\t\u0005\u00033\u0014\u0019\u0005B\u0004\u0003Fm\u0011\r!a8\u0003\u0003YCa!a\u0011\u001c\u0001\u0004\u0011\u0005bBA<7\u0001\u0007!1\b\u0005\b\u0003_Z\u0002\u0019\u0001B!\u0011%\tih\u0007I\u0001\u0002\u0004\ty\bC\u0005\u0002\u0004n\u0001\n\u00111\u0001\u0002\u0006\"I\u0011qS\u000e\u0011\u0002\u0003\u0007\u0011\u0011T\u0001\u0017GJ,\u0017\r^3SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%iU1\u00111\u0016B,\u00053\"qAa\u0010\u001d\u0005\u0004\ty\u000eB\u0004\u0003Fq\u0011\r!a8\u0002-\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIU*b!!-\u0003`\t\u0005Da\u0002B ;\t\u0007\u0011q\u001c\u0003\b\u0005\u000bj\"\u0019AAp\u0003Y\u0019'/Z1uKJ+7m\u001c:eI\u0011,g-Y;mi\u00122TCBA\\\u0005O\u0012I\u0007B\u0004\u0003@y\u0011\r!a8\u0005\u000f\t\u0015cD1\u0001\u0002`\u0006\u0001\u0002O]8ek\u000e,'oQ1mY\n\f7m\u001b\u000b\u0005\u0005_\u0012)\bE\u0002X\u0005cJ1Aa\u001dY\u0005!\u0019\u0015\r\u001c7cC\u000e\\\u0007b\u0002B<?\u0001\u0007!\u0011P\u0001\baJ|W.[:f!\u0019\tYFa\u001f\u0002f%!!QPA/\u0005\u001d\u0001&o\\7jg\u0016$BAa\u001c\u0003\u0002\"9!1\u0011\u0011A\u0002\t\u0015\u0015\u0001C2bY2\u0014\u0017mY6\u0011\u000fI\u00129Ia#\u0002\u0012%\u0019!\u0011R\u001a\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0002BG\u0005'\u000b)'\u0004\u0002\u0003\u0010*\u0019!\u0011S\u001a\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0013yIA\u0002Uef\fQA\u001a7vg\"$\"!!\u0005\u0002\u0011MDW\u000f\u001e3po:\fab\u00197pg\u0016\u001cuN\\:v[\u0016\u00148\u000f")
public class KafkaClient
implements LazyLogging {
    private Admin adminClient;
    private final String kafkaAddress;
    private final String id;
    private final KafkaProducer<byte[], byte[]> rawProducer;
    private final KafkaProducer<String, String> producer;
    private final HashSet<KafkaConsumer<byte[], byte[]>> consumers;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KafkaClient kafkaClient = this;
        synchronized (kafkaClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private KafkaProducer<byte[], byte[]> rawProducer() {
        return this.rawProducer;
    }

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private HashSet<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    private Admin adminClient$lzycompute() {
        KafkaClient kafkaClient = this;
        synchronized (kafkaClient) {
            if (!this.bitmap$0) {
                this.adminClient = KafkaUtils$.MODULE$.createKafkaAdminClient(new KafkaConfig((Option)new Some(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.kafkaAddress)}))), (Option)None$.MODULE$, KafkaConfig$.MODULE$.apply$default$3(), KafkaConfig$.MODULE$.apply$default$4(), KafkaConfig$.MODULE$.apply$default$5(), KafkaConfig$.MODULE$.apply$default$6(), KafkaConfig$.MODULE$.apply$default$7(), KafkaConfig$.MODULE$.apply$default$8(), KafkaConfig$.MODULE$.apply$default$9()));
                this.bitmap$0 = true;
            }
        }
        return this.adminClient;
    }

    private Admin adminClient() {
        if (!this.bitmap$0) {
            return this.adminClient$lzycompute();
        }
        return this.adminClient;
    }

    public void createTopic(String name, int partitions) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(name, partitions, 1))).all().get();
    }

    public int createTopic$default$2() {
        return 5;
    }

    public void deleteTopic(String name) {
        this.adminClient().deleteTopics(Arrays.asList((Object[])new String[]{name})).all().get();
    }

    public Option<TopicDescription> topic(String name) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (Map)this.adminClient().describeTopics(Arrays.asList((Object[])new String[]{name})).allTopicNames().get()).toOption().map((Function1 & Serializable)x$1 -> (TopicDescription)x$1.get(name));
    }

    public Future<RecordMetadata> sendRawMessage(String topic, byte[] content) {
        return this.sendRawMessage(topic, null, content, this.sendRawMessage$default$4(), this.sendRawMessage$default$5(), this.sendRawMessage$default$6());
    }

    public Future<RecordMetadata> sendRawMessage(String topic, byte[] key, byte[] content, Option<Object> partition, Long timestamp, Headers headers) {
        Promise promise = Promise$.MODULE$.apply();
        ProducerRecord<byte[], byte[]> record = this.createRecord(topic, key, content, partition, timestamp, headers);
        this.rawProducer().send(record, this.producerCallback((Promise<RecordMetadata>)promise));
        return promise.future();
    }

    public Option<Object> sendRawMessage$default$4() {
        return None$.MODULE$;
    }

    public Long sendRawMessage$default$5() {
        return null;
    }

    public Headers sendRawMessage$default$6() {
        return KafkaRecordUtils$.MODULE$.emptyHeaders();
    }

    public <T> Future<RecordMetadata> sendMessage(String topic, T content, Encoder<T> evidence$1) {
        return this.sendMessage(topic, null, content, this.sendMessage$default$4(), this.sendMessage$default$5(), this.sendMessage$default$6(), evidence$1);
    }

    public <T> Future<RecordMetadata> sendMessage(String topic, String key, T content, Option<Object> partition, Long timestamp, Headers headers, Encoder<T> evidence$2) {
        String strContent = ConsumerRecordHelper$.MODULE$.asString(content, evidence$2);
        Promise promise = Promise$.MODULE$.apply();
        ProducerRecord<String, String> record = this.createRecord(topic, key, strContent, partition, timestamp, headers);
        this.producer().send(record, this.producerCallback((Promise<RecordMetadata>)promise));
        return promise.future();
    }

    public <T> Option<Object> sendMessage$default$4() {
        return None$.MODULE$;
    }

    public <T> Long sendMessage$default$5() {
        return null;
    }

    public <T> Headers sendMessage$default$6() {
        return KafkaRecordUtils$.MODULE$.emptyHeaders();
    }

    public synchronized KafkaConsumer<byte[], byte[]> createConsumer(Option<String> groupIdOpt) {
        String groupId = (String)groupIdOpt.getOrElse((Function0 & Serializable)() -> $this.id + "-" + UUID.randomUUID());
        Properties props = KafkaTestUtils$.MODULE$.createConsumerConnectorProperties(this.kafkaAddress, groupId);
        KafkaConsumer consumer = new KafkaConsumer(props);
        this.consumers().add((Object)consumer);
        return consumer;
    }

    public Option<String> createConsumer$default$1() {
        return None$.MODULE$;
    }

    private <K, V> ProducerRecord<K, V> createRecord(String topic, K key, V content, Option<Object> partition, Long timestamp, Headers headers) {
        return (ProducerRecord)partition.map((Function1 & Serializable)x$2 -> KafkaClient.$anonfun$createRecord$1(topic, timestamp, key, content, headers, BoxesRunTime.unboxToInt((Object)x$2))).getOrElse((Function0 & Serializable)() -> new ProducerRecord(topic, null, timestamp, key, content, (Iterable)headers));
    }

    private <K, V> Option<Object> createRecord$default$4() {
        return None$.MODULE$;
    }

    private <K, V> Long createRecord$default$5() {
        return null;
    }

    private <K, V> Headers createRecord$default$6() {
        return KafkaRecordUtils$.MODULE$.emptyHeaders();
    }

    private Callback producerCallback(Promise<RecordMetadata> promise) {
        return this.producerCallback((Function1<Try<RecordMetadata>, BoxedUnit>)(Function1 & Serializable)result -> {
            promise.complete(result);
            return BoxedUnit.UNIT;
        });
    }

    private Callback producerCallback(Function1<Try<RecordMetadata>, BoxedUnit> callback) {
        return (metadata, exception) -> {
            Success success;
            if (exception == null) {
                success = new Success((Object)metadata);
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error while sending kafka message", (Throwable)exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                success = new Failure((Throwable)exception);
            }
            Success result = success;
            callback.apply((Object)result);
        };
    }

    public void flush() {
        this.producer().flush();
    }

    public void shutdown() {
        this.closeConsumers();
        this.producer().close();
        this.rawProducer().close();
        this.adminClient().close();
    }

    public synchronized void closeConsumers() {
        this.consumers().foreach((Function1 & Serializable)x$3 -> {
            x$3.close(Duration.ofSeconds(1L));
            return BoxedUnit.UNIT;
        });
        this.consumers().clear();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$createRecord$1(String topic$1, Long timestamp$1, Object key$1, Object content$1, Headers headers$1, int x$2) {
        return new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer(x$2), timestamp$1, key$1, content$1, (Iterable)headers$1);
    }

    public KafkaClient(String kafkaAddress, String id) {
        this.kafkaAddress = kafkaAddress;
        this.id = id;
        LazyLogging.$init$((LazyLogging)this);
        this.rawProducer = KafkaTestUtils$.MODULE$.createRawKafkaProducer(kafkaAddress, id + "_raw");
        this.producer = KafkaTestUtils$.MODULE$.createKafkaProducer(kafkaAddress, id);
        this.consumers = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

