/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.kafka;

import java.util.Locale;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import pl.touk.nussknacker.engine.kafka.KafkaUtils$;
import pl.touk.nussknacker.engine.kafka.RichKafkaConsumer;
import scala.runtime.BoxesRunTime;

public final class KafkaTestUtils$ {
    public static final KafkaTestUtils$ MODULE$ = new KafkaTestUtils$();

    public KafkaProducer<byte[], byte[]> createRawKafkaProducer(String kafkaAddress, String id) {
        Properties props = this.createCommonProducerProps(kafkaAddress, id);
        props.put("key.serializer", ByteArraySerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("retries", Integer.toString(3));
        props.put("acks", "all");
        return new KafkaProducer(props);
    }

    public KafkaProducer<String, String> createKafkaProducer(String kafkaAddress, String id) {
        Properties props = this.createCommonProducerProps(kafkaAddress, id);
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("retries", Integer.toString(3));
        props.put("acks", "all");
        return new KafkaProducer(props);
    }

    private <K, T> Properties createCommonProducerProps(String kafkaAddress, String id) {
        Properties props = new Properties();
        props.put("bootstrap.servers", kafkaAddress);
        props.put("batch.size", "100000");
        KafkaUtils$.MODULE$.setClientId(props, id);
        return props;
    }

    public Properties createConsumerConnectorProperties(String kafkaAddress, String groupId) {
        Properties props = new Properties();
        props.put("group.id", groupId);
        props.put("bootstrap.servers", kafkaAddress);
        props.put("auto.offset.reset", "earliest");
        props.put("request.timeout.ms", BoxesRunTime.boxToInteger((int)2000));
        props.put("default.api.timeout.ms", BoxesRunTime.boxToInteger((int)2000));
        props.put("key.deserializer", ByteArrayDeserializer.class);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        props.setProperty("isolation.level", IsolationLevel.READ_COMMITTED.toString().toLowerCase(Locale.ROOT));
        return props;
    }

    public String createConsumerConnectorProperties$default$2() {
        return "testGroup";
    }

    public <K, M> RichKafkaConsumer<K, M> richConsumer(Consumer<K, M> consumer) {
        return new RichKafkaConsumer<K, M>(consumer);
    }

    private KafkaTestUtils$() {
    }
}

