/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.lite.kafka;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import cats.data.Validated;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.MetricRegistry;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import net.ceedubs.ficus.readers.NameMapper$;
import net.ceedubs.ficus.readers.ValueReader;
import org.apache.commons.io.FileUtils;
import pl.touk.nussknacker.engine.ModelData;
import pl.touk.nussknacker.engine.ModelData$;
import pl.touk.nussknacker.engine.api.JobData;
import pl.touk.nussknacker.engine.api.ProcessVersion$;
import pl.touk.nussknacker.engine.api.deployment.DeploymentData$;
import pl.touk.nussknacker.engine.graph.EspProcess;
import pl.touk.nussknacker.engine.lite.api.runtimecontext.LiteEngineRuntimeContextPreparer;
import pl.touk.nussknacker.engine.lite.kafka.HealthCheckServerRunner;
import pl.touk.nussknacker.engine.lite.kafka.KafkaTransactionalScenarioInterpreter;
import pl.touk.nussknacker.engine.lite.kafka.KafkaTransactionalScenarioInterpreter$;
import pl.touk.nussknacker.engine.lite.kafka.LiteKafkaJobData;
import pl.touk.nussknacker.engine.lite.kafka.NuKafkaRuntimeApp$delayedInit$body;
import pl.touk.nussknacker.engine.lite.metrics.dropwizard.DropwizardMetricsProviderFactory;
import pl.touk.nussknacker.engine.lite.metrics.dropwizard.LiteMetricRegistryFactory;
import pl.touk.nussknacker.engine.lite.metrics.dropwizard.LiteMetricRegistryFactory$;
import pl.touk.nussknacker.engine.marshall.ScenarioParser$;
import pl.touk.nussknacker.engine.util.JavaClassVersionChecker;
import pl.touk.nussknacker.engine.util.config.ConfigFactoryExt$;
import pl.touk.nussknacker.engine.util.config.CustomFicusInstances$;
import pl.touk.nussknacker.engine.util.loader.ModelClassLoader$;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class NuKafkaRuntimeApp$
implements App,
LazyLogging {
    public static NuKafkaRuntimeApp$ MODULE$;
    private /* synthetic */ Tuple2 x$1;
    private Path scenarioFileLocation;
    private Path deploymentConfigLocation;
    private EspProcess scenario;
    private LiteKafkaJobData liteKafkaJobData;
    private Config runtimeConfig;
    private ActorSystem system;
    private KafkaTransactionalScenarioInterpreter scenarioInterpreter;
    private HealthCheckServerRunner healthCheckServer;
    private transient Logger logger;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile transient boolean bitmap$trans$0;

    static {
        new NuKafkaRuntimeApp$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    private Logger logger$lzycompute() {
        NuKafkaRuntimeApp$ nuKafkaRuntimeApp$ = this;
        synchronized (nuKafkaRuntimeApp$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public Path scenarioFileLocation() {
        return this.scenarioFileLocation;
    }

    public Path deploymentConfigLocation() {
        return this.deploymentConfigLocation;
    }

    public EspProcess scenario() {
        return this.scenario;
    }

    public LiteKafkaJobData liteKafkaJobData() {
        return this.liteKafkaJobData;
    }

    public Config runtimeConfig() {
        return this.runtimeConfig;
    }

    public ActorSystem system() {
        return this.system;
    }

    public KafkaTransactionalScenarioInterpreter scenarioInterpreter() {
        return this.scenarioInterpreter;
    }

    private HealthCheckServerRunner healthCheckServer() {
        return this.healthCheckServer;
    }

    private Tuple2<Path, Path> parseArgs() {
        if (this.args().length < 1) {
            this.missingArgumentError("scenario_file_location");
        } else if (this.args().length < 2) {
            this.missingArgumentError("deployment_config_location");
        }
        return new Tuple2((Object)Path.of(this.args()[0], new String[0]), (Object)Path.of(this.args()[1], new String[0]));
    }

    private void missingArgumentError(String argumentName) {
        System.err.println(new StringBuilder(18).append("Missing ").append(argumentName).append(" argument!").toString());
        System.err.println("");
        System.err.println("Usage: ./run.sh scenario_file_location.json deployment_config_location.conf");
        throw scala.sys.package$.MODULE$.exit(1);
    }

    private EspProcess parseScenario(Path location) {
        BoxedUnit boxedUnit;
        String scenarioString = FileUtils.readFileToString((File)location.toFile());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Running scenario: {}", new Object[]{scenarioString});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Validated parsedScenario = ScenarioParser$.MODULE$.parse(scenarioString);
        return (EspProcess)parsedScenario.valueOr((Function1 & Serializable & scala.Serializable)err -> {
            System.err.println("Scenario file is not a valid json");
            System.err.println(new StringBuilder(14).append("Errors found: ").append(err.toList().mkString(", ")).toString());
            return scala.sys.package$.MODULE$.exit(2);
        });
    }

    private LiteKafkaJobData parseDeploymentConfig(Path path) {
        return (LiteKafkaJobData)CustomFicusInstances$.MODULE$.toFicusConfig(ConfigFactory.parseFile((File)path.toFile())).as((ValueReader)new ValueReader<LiteKafkaJobData>(){

            public <B> ValueReader<B> map(Function1<LiteKafkaJobData, B> f) {
                return ValueReader.map$((ValueReader)this, f);
            }

            public LiteKafkaJobData read(Config config, String path) {
                String string = path;
                String string2 = ".";
                return new LiteKafkaJobData(BoxesRunTime.unboxToInt((Object)CustomFicusInstances$.MODULE$.intValueReader().read(config, !(string != null ? !string.equals(string2) : string2 != null) ? NameMapper$.MODULE$.apply(NameMapper$.MODULE$.apply$default$1()).map("tasksCount") : new StringBuilder(1).append(path).append(".").append(NameMapper$.MODULE$.apply(NameMapper$.MODULE$.apply$default$1()).map("tasksCount")).toString())));
            }
            {
                ValueReader.$init$((ValueReader)this);
            }
        });
    }

    private KafkaTransactionalScenarioInterpreter prepareScenarioInterpreter(Config runtimeConfig, LiteKafkaJobData liteKafkaJobData) {
        Config modelConfig = runtimeConfig.getConfig("modelConfig");
        ModelData modelData = ModelData$.MODULE$.apply(modelConfig, ModelClassLoader$.MODULE$.apply((List)CustomFicusInstances$.MODULE$.toFicusConfig(modelConfig).as("classPath", CustomFicusInstances$.MODULE$.traversableReader(CustomFicusInstances$.MODULE$.urlValueReader(), List$.MODULE$.canBuildFrom()))));
        MetricRegistry metricRegistry = this.prepareMetricRegistry(runtimeConfig);
        LiteEngineRuntimeContextPreparer preparer = new LiteEngineRuntimeContextPreparer((Function1)new DropwizardMetricsProviderFactory(metricRegistry));
        JobData jobData = new JobData(this.scenario().metaData(), ProcessVersion$.MODULE$.empty(), DeploymentData$.MODULE$.empty());
        return KafkaTransactionalScenarioInterpreter$.MODULE$.apply(this.scenario(), jobData, liteKafkaJobData, modelData, preparer, (ExecutionContext)this.system().dispatcher());
    }

    private MetricRegistry prepareMetricRegistry(Config engineConfig) {
        LazyRef instanceId$lzy = new LazyRef();
        return new LiteMetricRegistryFactory((Function0 & Serializable & scala.Serializable)() -> NuKafkaRuntimeApp$.instanceId$1(instanceId$lzy)).prepareRegistry(engineConfig);
    }

    public static final /* synthetic */ void $anonfun$new$2(BoxedUnit _) {
    }

    private static final /* synthetic */ String instanceId$lzycompute$1(LazyRef instanceId$lzy$1) {
        String string;
        LazyRef lazyRef = instanceId$lzy$1;
        synchronized (lazyRef) {
            string = instanceId$lzy$1.initialized() ? (String)instanceId$lzy$1.value() : (String)instanceId$lzy$1.initialize(scala.sys.package$.MODULE$.env().getOrElse((Object)"INSTANCE_ID", (Function0 & Serializable & scala.Serializable)() -> LiteMetricRegistryFactory$.MODULE$.hostname()));
        }
        return string;
    }

    private static final String instanceId$1(LazyRef instanceId$lzy$1) {
        return instanceId$lzy$1.initialized() ? (String)instanceId$lzy$1.value() : NuKafkaRuntimeApp$.instanceId$lzycompute$1(instanceId$lzy$1);
    }

    public final void delayedEndpoint$pl$touk$nussknacker$engine$lite$kafka$NuKafkaRuntimeApp$1() {
        BoxedUnit boxedUnit;
        JavaClassVersionChecker.check();
        Tuple2<Path, Path> tuple2 = this.parseArgs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Path scenarioFileLocation = (Path)tuple2._1();
        Path deploymentConfigLocation = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)scenarioFileLocation, (Object)deploymentConfigLocation);
        this.x$1 = tuple22;
        this.scenarioFileLocation = (Path)this.x$1._1();
        this.deploymentConfigLocation = (Path)this.x$1._2();
        this.scenario = this.parseScenario(this.scenarioFileLocation());
        this.liteKafkaJobData = this.parseDeploymentConfig(this.deploymentConfigLocation());
        ClassLoader x$1 = this.getClass().getClassLoader();
        String x$2 = ConfigFactoryExt$.MODULE$.parseUnresolved$default$1();
        this.runtimeConfig = ConfigFactory.load((Config)ConfigFactoryExt$.MODULE$.parseUnresolved(x$2, x$1));
        this.system = ActorSystem$.MODULE$.apply("nu-kafka-runtime", this.runtimeConfig());
        this.scenarioInterpreter = this.prepareScenarioInterpreter(this.runtimeConfig(), this.liteKafkaJobData());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                BoxedUnit boxedUnit;
                if (NuKafkaRuntimeApp$.MODULE$.logger().underlying().isInfoEnabled()) {
                    NuKafkaRuntimeApp$.MODULE$.logger().underlying().info("Closing KafkaTransactionalScenarioInterpreter");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                NuKafkaRuntimeApp$.MODULE$.scenarioInterpreter().close();
            }
        });
        this.healthCheckServer = new HealthCheckServerRunner(this.system(), this.scenarioInterpreter());
        Await$.MODULE$.result((Awaitable)this.healthCheckServer().start().flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.scenarioInterpreter().run().map((Function1 & Serializable & scala.Serializable)_ -> {
            NuKafkaRuntimeApp$.$anonfun$new$2(_);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)MODULE$.system().dispatcher()), (ExecutionContext)this.system().dispatcher()), (Duration)Duration$.MODULE$.Inf());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Closing application NuKafkaRuntimeApp");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Await$.MODULE$.ready(this.healthCheckServer().stop(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        Await$.MODULE$.result((Awaitable)this.system().terminate(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    private NuKafkaRuntimeApp$() {
        MODULE$ = this;
        App.$init$((App)this);
        LazyLogging.$init$((LazyLogging)this);
        this.delayedInit((Function0<BoxedUnit>)new NuKafkaRuntimeApp$delayedInit$body(this));
    }
}

