/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi;

import cats.data.Validated;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.CirceUtil$;
import pl.touk.nussknacker.engine.api.EagerService;
import pl.touk.nussknacker.engine.api.component.Component;
import pl.touk.nussknacker.engine.api.component.ComponentDefinition;
import pl.touk.nussknacker.engine.api.component.ComponentDefinition$;
import pl.touk.nussknacker.engine.api.component.ComponentProvider;
import pl.touk.nussknacker.engine.api.component.NussknackerVersion;
import pl.touk.nussknacker.engine.api.process.ProcessObjectDependencies;
import pl.touk.nussknacker.engine.util.config.ConfigEnrichments$;
import pl.touk.nussknacker.openapi.OpenAPIServicesConfig;
import pl.touk.nussknacker.openapi.OpenAPIsConfig$;
import pl.touk.nussknacker.openapi.SwaggerService;
import pl.touk.nussknacker.openapi.SwaggerService$;
import pl.touk.nussknacker.openapi.discovery.SwaggerOpenApiDefinitionDiscovery$;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnricherCreator;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnricherCreator$;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnrichers$;
import pl.touk.nussknacker.openapi.parser.ServiceParseError;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0005\n\u0001IAQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005BIBQA\u0010\u0001\u0005B}BQa\u0012\u0001\u0005\n!CQ\u0001\u001b\u0001\u0005B%DQa\u001e\u0001\u0005\u0012aDq!a\u0002\u0001\t\u0003\nIA\u0001\rPa\u0016t\u0017\tU%D_6\u0004xN\\3oiB\u0013xN^5eKJT!AC\u0006\u0002\u000f=\u0004XM\\1qS*\u0011A\"D\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u000f\u001f\u0005!Ao\\;l\u0015\u0005\u0001\u0012A\u00019m\u0007\u0001\u0019B\u0001A\n\u001aGA\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u0011\u000e\u0003mQ!\u0001H\u000f\u0002\u0013\r|W\u000e]8oK:$(B\u0001\u0010 \u0003\r\t\u0007/\u001b\u0006\u0003A-\ta!\u001a8hS:,\u0017B\u0001\u0012\u001c\u0005E\u0019u.\u001c9p]\u0016tG\u000f\u0015:pm&$WM\u001d\t\u0003I-j\u0011!\n\u0006\u0003M\u001d\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001K\u0015\u0002\u0011QL\b/Z:bM\u0016T\u0011AK\u0001\u0004G>l\u0017B\u0001\u0017&\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0019\u0001\u001b\u0005I\u0011\u0001\u00049s_ZLG-\u001a:OC6,W#A\u001a\u0011\u0005QZdBA\u001b:!\t1T#D\u00018\u0015\tA\u0014#\u0001\u0004=e>|GOP\u0005\u0003uU\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!(F\u0001\u001ae\u0016\u001cx\u000e\u001c<f\u0007>tg-[4G_J,\u00050Z2vi&|g\u000e\u0006\u0002A\rB\u0011\u0011\tR\u0007\u0002\u0005*\u00111iJ\u0001\u0007G>tg-[4\n\u0005\u0015\u0013%AB\"p]\u001aLw\rC\u0003D\u0007\u0001\u0007\u0001)A\u0005m_\u001e,%O]8sgR\u0011\u0011\n\u0014\t\u0003))K!aS\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001b\u0012\u0001\rAT\u0001\tg\u0016\u0014h/[2fgB\u0019q\nV,\u000f\u0005A\u0013fB\u0001\u001cR\u0013\u00051\u0012BA*\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\t1K7\u000f\u001e\u0006\u0003'V\u0001B\u0001W/`K6\t\u0011L\u0003\u0002[7\u0006!A-\u0019;b\u0015\u0005a\u0016\u0001B2biNL!AX-\u0003\u0013Y\u000bG.\u001b3bi\u0016$\u0007C\u00011d\u001b\u0005\t'B\u00012\n\u0003\u0019\u0001\u0018M]:fe&\u0011A-\u0019\u0002\u0012'\u0016\u0014h/[2f!\u0006\u00148/Z#se>\u0014\bC\u0001\u0019g\u0013\t9\u0017B\u0001\bTo\u0006<w-\u001a:TKJ4\u0018nY3\u0002\r\r\u0014X-\u0019;f)\rQgn\u001c\t\u0004\u001fR[\u0007C\u0001\u000em\u0013\ti7DA\nD_6\u0004xN\\3oi\u0012+g-\u001b8ji&|g\u000eC\u0003D\u000b\u0001\u0007\u0001\tC\u0003q\u000b\u0001\u0007\u0011/\u0001\u0007eKB,g\u000eZ3oG&,7\u000f\u0005\u0002sk6\t1O\u0003\u0002u;\u00059\u0001O]8dKN\u001c\u0018B\u0001<t\u0005e\u0001&o\\2fgN|%M[3di\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u00025A\u0014X\r]1sK\n\u000b7/Z#oe&\u001c\u0007.\u001a:De\u0016\fGo\u001c:\u0015\u0005e|\bC\u0001>~\u001b\u0005Y(B\u0001?\n\u0003%)gN]5dQ\u0016\u00148/\u0003\u0002\u007fw\n12k^1hO\u0016\u0014XI\u001c:jG\",'o\u0011:fCR|'\u000f\u0003\u0004D\r\u0001\u0007\u0011\u0011\u0001\t\u0004a\u0005\r\u0011bAA\u0003\u0013\t)r\n]3o\u0003BK5+\u001a:wS\u000e,7oQ8oM&<\u0017\u0001D5t\u0007>l\u0007/\u0019;jE2,G\u0003BA\u0006\u0003#\u00012\u0001FA\u0007\u0013\r\ty!\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019b\u0002a\u0001\u0003+\tqA^3sg&|g\u000eE\u0002\u001b\u0003/I1!!\u0007\u001c\u0005IqUo]:l]\u0006\u001c7.\u001a:WKJ\u001c\u0018n\u001c8")
public class OpenAPIComponentProvider
implements ComponentProvider,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public boolean isAutoLoaded() {
        return ComponentProvider.isAutoLoaded$((ComponentProvider)this);
    }

    private Logger logger$lzycompute() {
        OpenAPIComponentProvider openAPIComponentProvider = this;
        synchronized (openAPIComponentProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String providerName() {
        return "openAPI";
    }

    public Config resolveConfigForExecution(Config config) {
        List list;
        OpenAPIServicesConfig openAPIsConfig = (OpenAPIServicesConfig)ConfigEnrichments$.MODULE$.RichConfig(ConfigFactory.load((Config)config)).rootAs(OpenAPIsConfig$.MODULE$.openAPIServicesConfigVR());
        try {
            list = SwaggerOpenApiDefinitionDiscovery$.MODULE$.discoverOpenAPIServices(openAPIsConfig);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable ex = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenAPI service resolution failed. Will be used empty services lists", ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            List list2 = List$.MODULE$.empty();
            list = list2;
        }
        List services = list;
        List servicesToUse = (List)services.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Validated<ServiceParseError, SwaggerService>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Validated.Valid) {
                    Validated.Valid valid = (Validated.Valid)A1;
                    SwaggerService service = (SwaggerService)valid.a();
                    object = ConfigFactory.parseString((String)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)service), SwaggerService$.MODULE$.codecForSwaggerService()).spaces2()).root();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Validated<ServiceParseError, SwaggerService> x1) {
                Validated<ServiceParseError, SwaggerService> validated = x1;
                boolean bl = validated instanceof Validated.Valid;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
        this.logErrors(services);
        return config.withValue("services", (ConfigValue)ConfigValueFactory.fromIterable((Iterable)((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)servicesToUse).asJava())));
    }

    private void logErrors(List<Validated<ServiceParseError, SwaggerService>> services) {
        block2: {
            BoxedUnit boxedUnit;
            List errors = (List)services.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Validated<ServiceParseError, SwaggerService>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Validated.Invalid) {
                        Validated.Invalid invalid = (Validated.Invalid)A1;
                        ServiceParseError serviceError = (ServiceParseError)invalid.e();
                        object = new StringBuilder(3).append(serviceError.name().value()).append(" (").append(serviceError.errors().toList().mkString(", ")).append(")").toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Validated<ServiceParseError, SwaggerService> x1) {
                    Validated<ServiceParseError, SwaggerService> validated = x1;
                    boolean bl = validated instanceof Validated.Invalid;
                    return bl;
                }
            }, List$.MODULE$.canBuildFrom());
            if (!errors.nonEmpty()) break block2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to parse following services: {}", new Object[]{errors.mkString(", ")});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public List<ComponentDefinition> create(Config config, ProcessObjectDependencies dependencies) {
        OpenAPIServicesConfig openAPIsConfig = (OpenAPIServicesConfig)ConfigEnrichments$.MODULE$.RichConfig(config).rootAs(OpenAPIsConfig$.MODULE$.openAPIServicesConfigVR());
        String serviceDefinitionConfig = config.getList("services").render(ConfigRenderOptions.concise());
        List swaggerServices = (List)CirceUtil$.MODULE$.decodeJsonUnsafe(serviceDefinitionConfig, "Failed to parse service config", Decoder$.MODULE$.decodeList(SwaggerService$.MODULE$.codecForSwaggerService()));
        SwaggerEnricherCreator creator = this.prepareBaseEnricherCreator(openAPIsConfig);
        return ((TraversableOnce)SwaggerEnrichers$.MODULE$.prepare(openAPIsConfig, (List<SwaggerService>)swaggerServices, creator).map((Function1 & Serializable & scala.Serializable)service -> {
            String x$1 = service.name().value();
            EagerService x$2 = service.service();
            Option<String> x$3 = service.documentation();
            Option x$4 = ComponentDefinition$.MODULE$.apply$default$3();
            return new ComponentDefinition(x$1, (Component)x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public SwaggerEnricherCreator prepareBaseEnricherCreator(OpenAPIServicesConfig config) {
        return SwaggerEnricherCreator$.MODULE$.apply(config.httpClientConfig());
    }

    public boolean isCompatible(NussknackerVersion version) {
        return true;
    }

    public OpenAPIComponentProvider() {
        ComponentProvider.$init$((ComponentProvider)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

