/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi.parser;

import cats.Invariant;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.kernel.Semigroup;
import cats.syntax.ValidatedIdSyntax$;
import cats.syntax.package;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.Serializable;
import java.util.Map;
import pl.touk.nussknacker.engine.api.util.ReflectUtils$;
import pl.touk.nussknacker.openapi.ApiKeyConfig;
import pl.touk.nussknacker.openapi.ApiKeyInCookie;
import pl.touk.nussknacker.openapi.ApiKeyInHeader;
import pl.touk.nussknacker.openapi.ApiKeyInQuery;
import pl.touk.nussknacker.openapi.OpenAPISecurityConfig;
import pl.touk.nussknacker.openapi.SwaggerSecurity;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;

public final class SecuritiesParser$
implements LazyLogging {
    public static SecuritiesParser$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SecuritiesParser$();
    }

    private Logger logger$lzycompute() {
        SecuritiesParser$ securitiesParser$ = this;
        synchronized (securitiesParser$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> parseSwaggerSecurities(List<SecurityRequirement> securityRequirements, Option<scala.collection.immutable.Map<String, SecurityScheme>> securitySchemes, scala.collection.immutable.Map<String, OpenAPISecurityConfig> securitiesConfigs) {
        Validated validated;
        List<SecurityRequirement> list = securityRequirements;
        if (Nil$.MODULE$.equals(list)) {
            validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$));
        } else {
            Validated validated2;
            Option<scala.collection.immutable.Map<String, SecurityScheme>> option = securitySchemes;
            if (None$.MODULE$.equals(option)) {
                validated2 = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)"There is no security scheme definition in the openAPI definition"));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Map securitySchemes2 = (scala.collection.immutable.Map)some.value();
                validated2 = ((Validated)((TraversableOnce)securityRequirements.view().map((Function1 & Serializable & scala.Serializable)securityRequirement -> MODULE$.matchSecuritiesForRequiredSchemes((List<String>)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)securityRequirement).asScala()).keys().toList(), (scala.collection.immutable.Map<String, SecurityScheme>)securitySchemes2, securitiesConfigs), SeqView$.MODULE$.canBuildFrom())).foldLeft((Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)"No security requirement can be met because:")), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.findValid((Function0 & Serializable & scala.Serializable)() -> x$2, NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).leftMap((Function1 & Serializable & scala.Serializable)errors -> NonEmptyList$.MODULE$.one((Object)errors.toList().mkString(" ")));
            } else {
                throw new MatchError(option);
            }
            validated = validated2;
        }
        return validated;
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> matchSecuritiesForRequiredSchemes(List<String> requiredSchemesNames, scala.collection.immutable.Map<String, SecurityScheme> securitySchemes, scala.collection.immutable.Map<String, OpenAPISecurityConfig> securitiesConfigs) {
        return (Validated)((LinearSeqOptimized)requiredSchemesNames.map((Function1 & Serializable & scala.Serializable)schemeName -> {
            Validated securityScheme = Validated$.MODULE$.fromOption(securitySchemes.get(schemeName), (Function0 & Serializable & scala.Serializable)() -> NonEmptyList$.MODULE$.of((Object)new StringBuilder(57).append("there is no security scheme definition for scheme name \"").append((String)schemeName).append("\"").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            Validated securityConfig = Validated$.MODULE$.fromOption(securitiesConfigs.get(schemeName), (Function0 & Serializable & scala.Serializable)() -> NonEmptyList$.MODULE$.of((Object)new StringBuilder(46).append("there is no security config for scheme name \"").append((String)schemeName).append("\"").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            return ((Validated)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)securityScheme, (Object)securityConfig)).tupled((Invariant)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).andThen((Function1 & Serializable & scala.Serializable)t -> MODULE$.getSecurityFromSchemeAndConfig((SecurityScheme)t._1(), (OpenAPISecurityConfig)t._2(), (String)schemeName));
        }, List$.MODULE$.canBuildFrom())).foldLeft((Object)ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.combine(x$4, NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList(), (Semigroup)implicits$.MODULE$.catsKernelStdMonoidForList()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> getSecurityFromSchemeAndConfig(SecurityScheme securityScheme, OpenAPISecurityConfig securityConfig, String schemeName) {
        Tuple2 tuple2 = new Tuple2((Object)securityScheme.getType(), (Object)securityConfig);
        if (tuple2 != null) {
            SecurityScheme.Type type = (SecurityScheme.Type)tuple2._1();
            OpenAPISecurityConfig apiKeyConfig = (OpenAPISecurityConfig)tuple2._2();
            if (SecurityScheme.Type.APIKEY.equals(type) && apiKeyConfig instanceof ApiKeyConfig) {
                ApiKeyConfig apiKeyConfig2 = (ApiKeyConfig)apiKeyConfig;
                return this.getApiKeySecurity(securityScheme, apiKeyConfig2, schemeName);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        SecurityScheme.Type otherType = (SecurityScheme.Type)tuple2._1();
        if (otherType == null) throw new MatchError((Object)tuple2);
        SecurityScheme.Type type = otherType;
        String securityConfigClassName = ReflectUtils$.MODULE$.simpleNameWithoutSuffix(securityConfig.getClass());
        return ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringBuilder(103).append("Security type ").append(type).append(" is not supported yet or (").append(type).append(", ").append(securityConfigClassName).append(") is a mismatch security scheme type and security config pair").toString()));
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> getApiKeySecurity(SecurityScheme securityScheme, ApiKeyConfig apiKeyConfig, String schemeName) {
        Validated validated;
        String name = securityScheme.getName();
        String key = apiKeyConfig.apiKeyValue();
        SecurityScheme.In in = securityScheme.getIn();
        if (SecurityScheme.In.QUERY.equals(in)) {
            ApiKeyInQuery apiKeyInQuery = new ApiKeyInQuery(name, key);
            validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$.$colon$colon((Object)apiKeyInQuery)));
        } else if (SecurityScheme.In.HEADER.equals(in)) {
            ApiKeyInHeader apiKeyInHeader = new ApiKeyInHeader(name, key);
            validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$.$colon$colon((Object)apiKeyInHeader)));
        } else if (SecurityScheme.In.COOKIE.equals(in)) {
            ApiKeyInCookie apiKeyInCookie = new ApiKeyInCookie(name, key);
            validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$.$colon$colon((Object)apiKeyInCookie)));
        } else {
            throw new MatchError((Object)in);
        }
        return validated;
    }

    private SecuritiesParser$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

