/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi.parser;

import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Collections;
import pl.touk.nussknacker.engine.util.ResourceLoader$;
import pl.touk.nussknacker.openapi.OpenAPIServicesConfig;
import pl.touk.nussknacker.openapi.SwaggerService;
import pl.touk.nussknacker.openapi.parser.ParseToSwaggerServices$;
import pl.touk.nussknacker.openapi.parser.ServiceParseError;
import scala.Function0;
import scala.Option$;
import scala.Serializable;
import scala.collection.immutable.List;

public final class SwaggerParser$
implements LazyLogging {
    public static SwaggerParser$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SwaggerParser$();
    }

    private Logger logger$lzycompute() {
        SwaggerParser$ swaggerParser$ = this;
        synchronized (swaggerParser$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public List<Validated<ServiceParseError, SwaggerService>> parse(String rawSwagger, OpenAPIServicesConfig openAPIsConfig) {
        OpenAPI openapi = this.parseToSwagger(rawSwagger);
        return ParseToSwaggerServices$.MODULE$.apply(openapi, openAPIsConfig);
    }

    public List<Validated<ServiceParseError, SwaggerService>> loadFromResource(String path, OpenAPIServicesConfig openAPIsConfig) {
        return this.parse(ResourceLoader$.MODULE$.load(path), openAPIsConfig);
    }

    public OpenAPI parseToSwagger(String rawSwagger) {
        SwaggerParseResult swagger30 = new OpenAPIV3Parser().readContents(rawSwagger);
        return (OpenAPI)Option$.MODULE$.apply((Object)swagger30.getOpenAPI()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            SwaggerParseResult swagger20 = new SwaggerConverter().readContents(rawSwagger, Collections.emptyList(), new ParseOptions());
            if (swagger20.getOpenAPI() == null) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Failed to parse with swagger 3.0: ").append(swagger30.getMessages()).append(" and 2.0 ").append(swagger20.getMessages()).toString());
            }
            return swagger20.getOpenAPI();
        });
    }

    private SwaggerParser$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

