/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.sql.db.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import pl.touk.nussknacker.sql.db.schema.DbParameterMetaData;
import pl.touk.nussknacker.sql.db.schema.DialectMetaData;
import pl.touk.nussknacker.sql.db.schema.QueryMetaData;
import pl.touk.nussknacker.sql.db.schema.SchemaDefinition;
import pl.touk.nussknacker.sql.db.schema.TableDefinition$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAB\u0004\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003'\u0001\u0011\u0005q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003C\u0001\u0011\u00051I\u0001\nEE6+G/\u0019#bi\u0006\u0004&o\u001c<jI\u0016\u0014(B\u0001\u0005\n\u0003\u0019\u00198\r[3nC*\u0011!bC\u0001\u0003I\nT!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005Ya.^:tW:\f7m[3s\u0015\t\u0001\u0012#\u0001\u0003u_V\\'\"\u0001\n\u0002\u0005Ad7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017!D4fi\u000e{gN\\3di&|g\u000eE\u0002\u0017;}I!AH\f\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0011%\u001b\u0005\t#B\u0001\u0007#\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!J\u0011\u0003\u0015\r{gN\\3di&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u0003\u001dAQa\u0007\u0002A\u0002q\t!cZ3u\t&\fG.Z2u\u001b\u0016$\u0018\rR1uCR\tQ\u0006\u0005\u0002*]%\u0011qf\u0002\u0002\u0010\t&\fG.Z2u\u001b\u0016$\u0018\rR1uC\u0006\u0001r-\u001a;Rk\u0016\u0014\u00180T3uC\u0012\u000bG/\u0019\u000b\u0003eU\u0002\"!K\u001a\n\u0005Q:!!D)vKJLX*\u001a;b\t\u0006$\u0018\rC\u00037\t\u0001\u0007q'A\u0003rk\u0016\u0014\u0018\u0010\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003u]i\u0011a\u000f\u0006\u0003yM\ta\u0001\u0010:p_Rt\u0014B\u0001 \u0018\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y:\u0012aE4fiN\u001b\u0007.Z7b\t\u00164\u0017N\\5uS>tG#\u0001#\u0011\u0005%*\u0015B\u0001$\b\u0005A\u00196\r[3nC\u0012+g-\u001b8ji&|g\u000e")
public class DbMetaDataProvider {
    private final Function0<Connection> getConnection;

    public DialectMetaData getDialectMetaData() {
        DialectMetaData dialectMetaData;
        try (Connection conn = (Connection)this.getConnection.apply();){
            DatabaseMetaData metaData = conn.getMetaData();
            dialectMetaData = new DialectMetaData(metaData.getIdentifierQuoteString());
        }
        return dialectMetaData;
    }

    public QueryMetaData getQueryMetaData(String query) {
        QueryMetaData queryMetaData;
        try (Connection conn = (Connection)this.getConnection.apply();
             PreparedStatement statement = conn.prepareStatement(query);){
            queryMetaData = new QueryMetaData(TableDefinition$.MODULE$.apply(statement.getMetaData()), new DbParameterMetaData(statement.getParameterMetaData().getParameterCount()));
        }
        return queryMetaData;
    }

    public SchemaDefinition getSchemaDefinition() {
        SchemaDefinition schemaDefinition;
        try (Connection connection = (Connection)this.getConnection.apply();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(null, connection.getSchema(), "%", (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"TABLE", "VIEW", "SYNONYM"})).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            Nil$ results = Nil$.MODULE$;
            int columnNameIndex = 3;
            while (tables.next()) {
                String str = tables.getString(columnNameIndex);
                results = (List)results.$colon$plus((Object)str, List$.MODULE$.canBuildFrom());
            }
            schemaDefinition = new SchemaDefinition((List<String>)results);
        }
        return schemaDefinition;
    }

    public DbMetaDataProvider(Function0<Connection> getConnection) {
        this.getConnection = getConnection;
    }
}

