/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.gasper;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;
import pl.wavesoftware.eid.utils.EidPreconditions;
import pl.wavesoftware.gasper.GasperBuilder;
import pl.wavesoftware.gasper.GasperConfigurations;
import pl.wavesoftware.gasper.internal.Executor;
import pl.wavesoftware.gasper.internal.Logger;
import pl.wavesoftware.gasper.internal.Settings;
import pl.wavesoftware.gasper.internal.maven.MavenResolver;

public final class Gasper
implements TestRule {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Gasper.class);
    public static final int DEFAULT_PORT_AVAILABLE_MAX_SECONDS = 60;
    public static final int DEFAULT_DEPLOYMENT_MAX_SECONDS = 30;
    public static final String DEFAULT_CONTEXT = "/";
    private static final String FIGLET;
    private final Settings settings;
    private Path artifact;
    private Executor executor;
    private Logger logger;

    public static GasperBuilder configure() {
        return new GasperBuilder();
    }

    public static GasperConfigurations configurations() {
        return new GasperConfigurations();
    }

    public Integer getPort() {
        return this.settings.getPort();
    }

    public String getAddress() {
        return this.settings.getEndpoint().fullAddress();
    }

    public Statement apply(Statement base, Description description) {
        return (Statement)EidPreconditions.tryToExecute(() -> {
            this.setup();
            this.before();
            return new GasperStatement(base, this::after);
        }, (String)"20160305:004035");
    }

    private void setup() {
        this.log(FIGLET, new Object[0]);
        MavenResolver resolver = new MavenResolver(this.settings.getPomfile());
        this.artifact = resolver.getBuildArtifact(this.settings.getPackaging(), this.settings.getClassifier());
        File workingDirectory = resolver.getBuildDirectory();
        List<String> command = this.buildCommand();
        this.log("Command to be executed: \"%s\"", command.stream().collect(Collectors.joining(" ")));
        this.executor = new Executor(command, workingDirectory, this.settings);
    }

    private void before() throws IOException {
        this.executor.start();
        this.log("All looks ready, running tests...", new Object[0]);
    }

    private void after() {
        this.log("Testing on server completed.", new Object[0]);
        this.executor.stop();
    }

    private List<String> buildCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        this.buildJavaOptions(command);
        command.add("-jar");
        command.add(this.artifact.toAbsolutePath().toString());
        return command;
    }

    private void buildJavaOptions(List<String> command) {
        command.addAll(this.settings.getJvmOptions());
        command.addAll(this.settings.getSystemProperties().entrySet().stream().map(entry -> String.format("-D%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList()));
    }

    private void log(String frmt, Object ... args) {
        this.ensureLogger();
        this.logger.info(String.format(frmt, args));
    }

    private void ensureLogger() {
        if (this.logger == null) {
            this.logger = new Logger(log, this.settings);
        }
    }

    @ConstructorProperties(value={"settings"})
    protected Gasper(Settings settings) {
        this.settings = settings;
    }

    static {
        InputStream is = Gasper.class.getClassLoader().getResourceAsStream("gasper.txt");
        FIGLET = (String)EidPreconditions.tryToExecute(() -> CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8)), (String)"20160305:201329");
    }

    @FunctionalInterface
    private static interface Procedure {
        public void execute();
    }

    private static class GasperStatement
    extends Statement {
        private final Statement base;
        private final Procedure procedure;

        public void evaluate() throws Throwable {
            try {
                this.base.evaluate();
            }
            finally {
                this.procedure.execute();
            }
        }

        @ConstructorProperties(value={"base", "procedure"})
        public GasperStatement(Statement base, Procedure procedure) {
            this.base = base;
            this.procedure = procedure;
        }
    }

    protected static interface RunnerCreator {
        default public Gasper create(Settings settings) {
            return new Gasper(settings);
        }
    }
}

