/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.gasper;

import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.event.Level;
import pl.wavesoftware.eid.utils.EidPreconditions;
import pl.wavesoftware.gasper.Gasper;
import pl.wavesoftware.gasper.internal.Executor;
import pl.wavesoftware.gasper.internal.HttpEndpoint;
import pl.wavesoftware.gasper.internal.Settings;

public final class GasperBuilder
implements Gasper.RunnerCreator {
    private String packaging = "jar";
    private String classifier = "";
    private Map<String, String> systemProperties = new LinkedHashMap<String, String>();
    private List<String> jvmOptions = new ArrayList<String>();
    private Map<String, String> environment = new LinkedHashMap<String, String>();
    private String systemPropertyForPort;
    private Integer port;
    private boolean inheritIO = false;
    private String context = "/";
    private int portAvailableMaxTime = 60;
    private int deploymentMaxTime = 30;
    private Function<HttpEndpoint, Boolean> contextChecker = Executor.DEFAULT_CONTEXT_CHECKER;
    private Path pomfile = Paths.get("./pom.xml", new String[0]);
    private Level level = Level.INFO;

    protected GasperBuilder() {
    }

    public GasperBuilder withArtifactPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public GasperBuilder withArtifactClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public GasperBuilder withEnvironmentVariable(String key, String value) {
        this.environment.put(key, value);
        return this;
    }

    public GasperBuilder withSystemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        return this;
    }

    public GasperBuilder withJVMOptions(String ... options) {
        Collections.addAll(this.jvmOptions, options);
        return this;
    }

    public GasperBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public GasperBuilder usingSystemPropertyForPort(String systemPropertyForPort) {
        this.systemPropertyForPort = systemPropertyForPort;
        return this;
    }

    public GasperBuilder usingPomFile(Path pomfile) {
        this.pomfile = pomfile;
        return this;
    }

    public GasperBuilder withTestApplicationLoggingOnConsole() {
        return this.withTestApplicationLoggingOnConsole(true);
    }

    public GasperBuilder withTestApplicationLoggingOnConsole(boolean inheritIO) {
        this.inheritIO = inheritIO;
        return this;
    }

    public GasperBuilder withMaxStartupTime(int seconds) {
        this.portAvailableMaxTime = seconds;
        return this;
    }

    public GasperBuilder withMaxDeploymentTime(int seconds) {
        this.deploymentMaxTime = seconds;
        return this;
    }

    public GasperBuilder waitForWebContext(String context) {
        this.context = context;
        return this;
    }

    public GasperBuilder usingWebContextChecker(Function<HttpEndpoint, Boolean> contextChecker) {
        this.contextChecker = contextChecker;
        return this;
    }

    public GasperBuilder silentGasperMessages() {
        this.usingLogLevel(Level.WARN);
        return this;
    }

    public GasperBuilder usingLogLevel(Level level) {
        this.level = level;
        return this;
    }

    public Gasper build() {
        if (this.port == null) {
            this.port = GasperBuilder.findNotBindedPort();
        }
        if (this.systemPropertyForPort != null) {
            this.withSystemProperty(this.systemPropertyForPort, this.port.toString());
        }
        Settings settings = new Settings(this.packaging, this.classifier, this.port, this.systemProperties, this.jvmOptions, this.environment, this.inheritIO, this.context, this.contextChecker, this.portAvailableMaxTime, this.deploymentMaxTime, this.pomfile, this.level);
        return this.create(settings);
    }

    private static Integer findNotBindedPort() {
        return (Integer)EidPreconditions.tryToExecute(() -> {
            try (ServerSocket socket = new ServerSocket(0);){
                Integer n = socket.getLocalPort();
                return n;
            }
        }, (String)"20160305:202934");
    }
}

