/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.gasper.internal;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.LoggerFactory;
import pl.wavesoftware.eid.exceptions.Eid;
import pl.wavesoftware.eid.exceptions.EidIllegalStateException;
import pl.wavesoftware.gasper.internal.HttpEndpoint;
import pl.wavesoftware.gasper.internal.Logger;
import pl.wavesoftware.gasper.internal.Settings;

public class Executor {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Executor.class);
    public static final int WAIT_STEP = 125;
    public static final int WAIT_STEPS_IN_SECOND = 8;
    public static final Function<HttpEndpoint, Boolean> DEFAULT_CONTEXT_CHECKER = Executor::check;
    private static final int HTTP_OK = 200;
    private static final int HTTP_BAD_REQUEST = 400;
    private final List<String> command;
    private final File workingDirectory;
    private final Settings settings;
    private Process process;
    private Logger logger;

    public void start() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(this.command);
        pb.directory(this.workingDirectory);
        if (this.settings.isInheritIO()) {
            pb.inheritIO();
        } else {
            this.logToFile(pb);
        }
        if (!this.settings.getEnvironment().isEmpty()) {
            pb.environment().putAll(this.settings.getEnvironment());
        }
        this.log("Starting server process", new Object[0]);
        this.process = pb.start();
        this.startAndWaitForPort();
        this.waitForHttpContext();
    }

    public void stop() {
        this.log("Stopping server process", new Object[0]);
        this.process.destroy();
    }

    private void waitForHttpContext() {
        String context = this.settings.getContext();
        int maxWait = this.settings.getDeploymentMaxTime();
        this.log("Waiting for deployment for context: \"%s\" to happen...", context);
        boolean ok = this.waitForContextToBecomeAvailable(context, maxWait);
        if (!ok) {
            throw new EidIllegalStateException(new Eid("20160305:123206"), "Context %s in not available after waiting %s seconds, aborting!", new Object[]{context, maxWait});
        }
    }

    private boolean waitForContextToBecomeAvailable(String context, int maxSeconds) {
        return this.waitOnProcess(maxSeconds, step -> {
            if (this.isContextAvailable()) {
                int waited = 125 * step;
                this.log("Context \"%s\" became available after ~%dms!", context, waited);
                return true;
            }
            return false;
        });
    }

    private boolean waitForPortToBecomeAvailable(int port, int maxSeconds) {
        return this.waitOnProcess(maxSeconds, step -> {
            if (Executor.isPortTaken(port)) {
                int waited = 125 * step;
                this.log("Port %d became available after ~%dms!", port, waited);
                return true;
            }
            return false;
        });
    }

    private boolean waitOnProcess(int maxSeconds, Function<Integer, Boolean> supplier) {
        for (int i = 1; i <= maxSeconds * 8; ++i) {
            try {
                this.process.waitFor(125L, TimeUnit.MILLISECONDS);
                if (!supplier.apply(i).booleanValue()) continue;
                return true;
            }
            catch (InterruptedException e) {
                log.error("Tried to wait 125ms, failed: " + e.getLocalizedMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private static Boolean check(HttpEndpoint endpoint) {
        String address = endpoint.fullAddress();
        try {
            HttpResponse response = Unirest.head((String)address).asBinary();
            int status = response.getStatus();
            return status >= 200 && status < 400;
        }
        catch (UnirestException e) {
            EidIllegalStateException ex = new EidIllegalStateException(new Eid("20160305:125410"), (Throwable)e);
            log.error(ex.getEid().makeLogMessage("Can't make http request - %s", new Object[]{e.getLocalizedMessage()}), (Throwable)ex);
            return false;
        }
    }

    private boolean isContextAvailable() {
        HttpEndpoint endpoint = this.settings.getEndpoint();
        return this.settings.getContextChecker().apply(endpoint);
    }

    private void startAndWaitForPort() {
        Integer port = this.settings.getPort();
        this.log("Waiting for port: %d to became active...", port);
        boolean ok = this.waitForPortToBecomeAvailable(port, this.settings.getPortAvailableMaxTime());
        if (!ok) {
            throw new EidIllegalStateException(new Eid("20160305:003452"), "Process %s probably didn't started well after maximum wait time is reached: %s", new Object[]{this.command.toString(), this.settings.getPortAvailableMaxTime()});
        }
    }

    private void logToFile(ProcessBuilder pb) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        Path logFile = tempDir.toPath().resolve("gasper.log");
        pb.redirectErrorStream(true);
        pb.redirectOutput(logFile.toFile());
        this.log("Logging server messages to: %s", logFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortTaken(int port) {
        try (ServerSocket ignored = new ServerSocket(port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            log.trace(String.format("Port %d taken", port), (Throwable)ex);
            return true;
        }
    }

    private void log(String frmt, Object ... args) {
        this.ensureLogger();
        this.logger.info(String.format(frmt, args));
    }

    private void ensureLogger() {
        if (this.logger == null) {
            this.logger = new Logger(log, this.settings);
        }
    }

    @ConstructorProperties(value={"command", "workingDirectory", "settings"})
    public Executor(List<String> command, File workingDirectory, Settings settings) {
        this.command = command;
        this.workingDirectory = workingDirectory;
        this.settings = settings;
    }
}

