/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.gasper.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.event.Level;
import pl.wavesoftware.gasper.internal.HttpEndpoint;

public class Settings {
    private final String packaging;
    private final String classifier;
    private final int port;
    private final Map<String, String> systemProperties;
    private final List<String> jvmOptions;
    private final Map<String, String> environment;
    private final boolean inheritIO;
    private final String context;
    private final Function<HttpEndpoint, Boolean> contextChecker;
    private final int portAvailableMaxTime;
    private final int deploymentMaxTime;
    private final Path pomfile;
    private final Level level;
    private HttpEndpoint endpoint;

    public Map<String, String> getSystemProperties() {
        return ImmutableMap.copyOf(this.systemProperties);
    }

    public List<String> getJvmOptions() {
        return ImmutableList.copyOf(this.jvmOptions);
    }

    public Map<String, String> getEnvironment() {
        return ImmutableMap.copyOf(this.environment);
    }

    public HttpEndpoint getEndpoint() {
        this.ensureHttpEndpoint();
        return this.endpoint;
    }

    private void ensureHttpEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new HttpEndpoint("http", "localhost", this.port, this.context, HttpEndpoint.DEFAULT_QUERY);
        }
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isInheritIO() {
        return this.inheritIO;
    }

    public String getContext() {
        return this.context;
    }

    public Function<HttpEndpoint, Boolean> getContextChecker() {
        return this.contextChecker;
    }

    public int getPortAvailableMaxTime() {
        return this.portAvailableMaxTime;
    }

    public int getDeploymentMaxTime() {
        return this.deploymentMaxTime;
    }

    public Path getPomfile() {
        return this.pomfile;
    }

    public Level getLevel() {
        return this.level;
    }

    @ConstructorProperties(value={"packaging", "classifier", "port", "systemProperties", "jvmOptions", "environment", "inheritIO", "context", "contextChecker", "portAvailableMaxTime", "deploymentMaxTime", "pomfile", "level"})
    public Settings(String packaging, String classifier, int port, Map<String, String> systemProperties, List<String> jvmOptions, Map<String, String> environment, boolean inheritIO, String context, Function<HttpEndpoint, Boolean> contextChecker, int portAvailableMaxTime, int deploymentMaxTime, Path pomfile, Level level) {
        this.packaging = packaging;
        this.classifier = classifier;
        this.port = port;
        this.systemProperties = systemProperties;
        this.jvmOptions = jvmOptions;
        this.environment = environment;
        this.inheritIO = inheritIO;
        this.context = context;
        this.contextChecker = contextChecker;
        this.portAvailableMaxTime = portAvailableMaxTime;
        this.deploymentMaxTime = deploymentMaxTime;
        this.pomfile = pomfile;
        this.level = level;
    }
}

